/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependencies.aether;

import io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifactPathResolver;
import io.github.ascopes.protobufmavenplugin.dependencies.ResolutionException;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.ProtobufMavenPluginRepositorySession;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.ScopeDependencyFilter;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.WildcardAwareDependencyTraverser;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
final class AetherMavenArtifactPathResolver
implements MavenArtifactPathResolver {
    private static final String DEFAULT_EXTENSION = "jar";
    private static final String DEFAULT_SCOPE = "compile";
    private static final Logger log = LoggerFactory.getLogger(AetherMavenArtifactPathResolver.class);
    private final MavenSession mavenSession;
    private final ArtifactHandler artifactHandler;
    private final ArtifactTypeRegistry artifactTypeRegistry;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySession;
    private final List<RemoteRepository> remoteRepositories;

    @Inject
    AetherMavenArtifactPathResolver(MavenSession mavenSession, RepositorySystem repositorySystem, ArtifactHandler artifactHandler) {
        this.repositorySession = new ProtobufMavenPluginRepositorySession(mavenSession.getRepositorySession());
        this.mavenSession = mavenSession;
        this.repositorySystem = repositorySystem;
        this.artifactTypeRegistry = this.repositorySession.getArtifactTypeRegistry();
        this.artifactHandler = artifactHandler;
        List artifactRepositories = mavenSession.getProjectBuildingRequest().getRemoteRepositories();
        this.remoteRepositories = RepositoryUtils.toRepos((List)artifactRepositories);
        log.debug("Injected artifact handler {}", (Object)artifactHandler);
        log.debug("Detected remote repositories as {}", this.remoteRepositories);
    }

    @Override
    public Path resolveArtifact(MavenArtifact artifact) throws ResolutionException {
        RepositorySystemSession repositorySession = this.mavenSession.getRepositorySession();
        DefaultArtifact aetherArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), this.classifierOrDefault(artifact.getClassifier()), this.extensionOrDefault(artifact.getType()), artifact.getVersion());
        log.info("Resolving artifact {} from repositories", (Object)aetherArtifact);
        ArtifactRequest artifactRequest = new ArtifactRequest((Artifact)aetherArtifact, this.remoteRepositories, null);
        try {
            Artifact resolvedArtifact = this.repositorySystem.resolveArtifact(repositorySession, artifactRequest).getArtifact();
            return this.determinePath(resolvedArtifact);
        }
        catch (ArtifactResolutionException ex) {
            throw new ResolutionException("Failed to resolve artifact " + String.valueOf(aetherArtifact) + " from repositories", ex);
        }
    }

    @Override
    public List<Path> resolveDependencies(Collection<? extends MavenArtifact> artifacts, DependencyResolutionDepth defaultDependencyResolutionDepth, Set<String> dependencyScopes, boolean includeProjectDependencies, boolean failOnInvalidDependencies) throws ResolutionException {
        DependencyResult dependencyResult;
        try {
            List dependenciesToResolve = Stream.concat(includeProjectDependencies ? this.getProjectDependencies() : Stream.of(new Dependency[0]), artifacts.stream().map(this.createDependency(defaultDependencyResolutionDepth))).collect(Collectors.toUnmodifiableList());
            log.debug("Attempting to resolve the following dependencies in this pass: {}", dependenciesToResolve);
            ScopeDependencyFilter scopeFilter = new ScopeDependencyFilter(dependencyScopes);
            CollectRequest collectRequest = new CollectRequest(dependenciesToResolve, null, this.remoteRepositories);
            DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, (DependencyFilter)scopeFilter);
            dependencyResult = this.repositorySystem.resolveDependencies(this.repositorySession, dependencyRequest);
        }
        catch (DependencyResolutionException ex) {
            dependencyResult = ex.getResult();
            if (dependencyResult == null || failOnInvalidDependencies) {
                throw new ResolutionException("Failed to resolve dependencies from repositories", ex);
            }
            log.warn("Error resolving one or more dependencies, dependencies may be missing during protobuf compilation! {}", (Object)ex.getMessage(), (Object)ex);
        }
        return dependencyResult.getArtifactResults().stream().map(ArtifactResult::getArtifact).map(this::determinePath).collect(Collectors.toUnmodifiableList());
    }

    private Stream<Dependency> getProjectDependencies() {
        return this.mavenSession.getCurrentProject().getDependencies().stream().map(this::createDependency);
    }

    private Artifact createArtifact(MavenArtifact artifact) {
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), this.classifierOrDefault(artifact.getClassifier()), this.extensionOrDefault(artifact.getType()), artifact.getVersion());
    }

    private Function<MavenArtifact, Dependency> createDependency(DependencyResolutionDepth defaultDependencyResolutionDepth) {
        return mavenArtifact -> {
            DependencyResolutionDepth effectiveDependencyResolutionDepth = Objects.requireNonNullElse(mavenArtifact.getDependencyResolutionDepth(), defaultDependencyResolutionDepth);
            List<Object> exclusions = effectiveDependencyResolutionDepth == DependencyResolutionDepth.DIRECT ? List.of(WildcardAwareDependencyTraverser.WILDCARD_EXCLUSION) : List.of();
            Artifact artifact = this.createArtifact((MavenArtifact)mavenArtifact);
            return new Dependency(artifact, DEFAULT_SCOPE, Boolean.valueOf(false), exclusions);
        };
    }

    private Dependency createDependency(org.apache.maven.model.Dependency mavenDependency) {
        DefaultArtifact artifact = new DefaultArtifact(mavenDependency.getGroupId(), mavenDependency.getArtifactId(), this.classifierOrDefault(mavenDependency.getClassifier()), null, mavenDependency.getVersion(), this.extensionToType(mavenDependency.getType()));
        List exclusions = mavenDependency.getExclusions().stream().map(mavenExclusion -> new Exclusion(mavenExclusion.getGroupId(), mavenExclusion.getArtifactId(), null, null)).collect(Collectors.toUnmodifiableList());
        return new Dependency((Artifact)artifact, mavenDependency.getScope(), Boolean.valueOf(mavenDependency.isOptional()), exclusions);
    }

    private @Nullable String classifierOrDefault(@Nullable String classifier) {
        if (classifier == null) {
            classifier = this.artifactHandler.getClassifier();
        }
        return classifier;
    }

    private @Nullable ArtifactType extensionToType(@Nullable String extension) {
        ArtifactType type = this.artifactTypeRegistry.get(extension = this.extensionOrDefault(extension));
        if (type == null) {
            log.debug("Could not resolve extension {} to any known Aether artifact type", (Object)extension);
        } else {
            log.debug("Resolved extension {} to Aether artifact type (classifier: {}, type: {}, id: {}, {})", new Object[]{extension, type.getClassifier(), type.getExtension(), type.getId(), type.getProperties()});
        }
        return type;
    }

    private String extensionOrDefault(@Nullable String extension) {
        if (extension == null) {
            extension = Objects.requireNonNullElse(this.artifactHandler.getExtension(), DEFAULT_EXTENSION);
        }
        return extension;
    }

    private Path determinePath(Artifact artifact) {
        Path path = artifact.getFile().toPath();
        return FileUtils.normalize(path);
    }
}

