/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import java.util.ArrayList;
import java.util.List;

public final class ArgumentFileBuilder {
    private final List<String> arguments = new ArrayList<String>();

    public ArgumentFileBuilder add(Object argument) {
        this.arguments.add(argument.toString());
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String argument : this.arguments) {
            if (argument.chars().noneMatch(c -> " \n\r\t'\"".indexOf(c) >= 0)) {
                sb.append(argument).append("\n");
                continue;
            }
            sb.append('\"');
            block9: for (int i = 0; i < argument.length(); ++i) {
                char nextChar = argument.charAt(i);
                switch (nextChar) {
                    case '\"': {
                        sb.append("\\\"");
                        continue block9;
                    }
                    case '\'': {
                        sb.append("\\'");
                        continue block9;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        continue block9;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block9;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block9;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block9;
                    }
                    default: {
                        sb.append(nextChar);
                    }
                }
            }
            sb.append("\"\n");
        }
        return sb.toString();
    }
}

