/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources;

import io.github.ascopes.protobufmavenplugin.generation.TemporarySpace;
import io.github.ascopes.protobufmavenplugin.sources.ImmutableProtoFileListing;
import io.github.ascopes.protobufmavenplugin.sources.ProtoFileFilter;
import io.github.ascopes.protobufmavenplugin.sources.ProtoFileListing;
import io.github.ascopes.protobufmavenplugin.utils.Digests;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class ProtoArchiveExtractor {
    private static final Logger log = LoggerFactory.getLogger(ProtoArchiveExtractor.class);
    private final TemporarySpace temporarySpace;

    @Inject
    public ProtoArchiveExtractor(TemporarySpace temporarySpace) {
        this.temporarySpace = temporarySpace;
    }

    public Optional<ProtoFileListing> extractProtoFiles(Path zipPath, ProtoFileFilter filter) throws IOException {
        try (FileSystem vfs = FileUtils.openZipAsFileSystem(zipPath);){
            Path vfsRoot = vfs.getRootDirectories().iterator().next();
            Collection<Path> sourceFiles = this.findProtoFilesInArchive(vfsRoot, filter);
            if (sourceFiles.isEmpty()) {
                Optional<ProtoFileListing> optional = Optional.empty();
                return optional;
            }
            Path extractionRoot = this.getExtractionRoot().resolve(this.generateUniqueName(zipPath));
            List<Path> targetFiles = FileUtils.rebaseFileTree(vfsRoot, extractionRoot, sourceFiles.stream());
            ImmutableProtoFileListing listing = ImmutableProtoFileListing.builder().addAllProtoFiles(targetFiles).protoFilesRoot(extractionRoot).build();
            Optional<ProtoFileListing> optional = Optional.of(listing);
            return optional;
        }
    }

    private Collection<Path> findProtoFilesInArchive(Path archiveRootPath, ProtoFileFilter filter) throws IOException {
        try (Stream<Path> stream = Files.walk(archiveRootPath, new FileVisitOption[0]);){
            Collection collection = stream.filter(filePath -> filter.matches(archiveRootPath, (Path)filePath)).peek(protoFile -> log.debug("Found proto file {} in archive {}", (Object)protoFile.toUri(), (Object)archiveRootPath)).collect(Collectors.toUnmodifiableList());
            return collection;
        }
    }

    private Path getExtractionRoot() {
        return this.temporarySpace.createTemporarySpace("archives");
    }

    private String generateUniqueName(Path path) {
        String digest = Digests.sha1(path.toAbsolutePath().toString());
        return FileUtils.getFileNameWithoutExtension(path) + "-" + digest;
    }
}

