/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public final class HostSystem {
    private static final Logger log = LoggerFactory.getLogger(HostSystem.class);
    private final String operatingSystem;
    private final String cpuArchitecture;
    private final String pathSeparator;
    private final Path workingDirectory;
    private final Path javaHome;
    private final Collection<Path> path;
    private final SortedSet<String> pathExt;

    @Inject
    public HostSystem() {
        this(System.getProperties(), System::getenv);
    }

    public HostSystem(Properties properties, Function<String, String> envProvider) {
        this.operatingSystem = properties.getProperty("os.name", "");
        log.debug("Reported OS is {}", (Object)this.operatingSystem);
        this.cpuArchitecture = properties.getProperty("os.arch", "");
        log.debug("Reported CPU architecture is {}", (Object)this.cpuArchitecture);
        this.pathSeparator = properties.getProperty("path.separator", "");
        this.workingDirectory = FileUtils.normalize(Path.of("", new String[0]));
        this.javaHome = FileUtils.normalize(Path.of(properties.getProperty("java.home", ""), new String[0]));
        log.debug("Reported java.home is {}", (Object)this.javaHome);
        this.path = HostSystem.tokenizeFilePath(this.pathSeparator, Objects.requireNonNullElse(envProvider.apply("PATH"), ""), paths -> paths.map(x$0 -> Path.of(x$0, new String[0])).map(FileUtils::normalize).distinct().filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toUnmodifiableList()));
        log.debug("Parsed PATH environment variable to {}", this.path);
        this.pathExt = HostSystem.tokenizeFilePath(this.pathSeparator, Objects.requireNonNullElse(envProvider.apply("PATHEXT"), ""), extensions -> extensions.collect(Collectors.toCollection(() -> new TreeSet(String::compareToIgnoreCase))));
        log.debug("Parsed PATHEXT environment variable to {}", this.pathExt);
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getCpuArchitecture() {
        return this.cpuArchitecture;
    }

    public boolean isProbablyLinux() {
        return this.operatingSystem.toLowerCase(Locale.ROOT).startsWith("linux");
    }

    public boolean isProbablyAndroid() {
        if (this.isProbablyLinux()) {
            return this.call("uname", "-o").filter("android"::equalsIgnoreCase).isPresent();
        }
        return false;
    }

    public boolean isProbablyMacOs() {
        return this.operatingSystem.toLowerCase(Locale.ROOT).startsWith("mac os");
    }

    public boolean isProbablyWindows() {
        return this.operatingSystem.toLowerCase(Locale.ROOT).startsWith("windows");
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Path getJavaExecutablePath() {
        return this.javaHome.resolve("bin").resolve(this.isProbablyWindows() ? "java.exe" : "java");
    }

    public Collection<Path> getSystemPath() {
        return this.path;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public SortedSet<String> getSystemPathExtensions() {
        return this.pathExt;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    Optional<String> call(String ... args) {
        ProcessBuilder procBuilder = new ProcessBuilder(args);
        procBuilder.environment().putAll(System.getenv());
        log.debug("Invoking command in subprocess {}", (Object)String.join((CharSequence)" ", args));
        try {
            Process proc = procBuilder.start();
            try {
                Optional<String> optional;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                    optional = Optional.ofNullable(reader.readLine()).map(String::trim);
                }
                return optional;
            }
            finally {
                proc.destroyForcibly();
            }
        }
        catch (IOException ex) {
            log.debug("Ignoring exception caught while executing subprocess", (Throwable)ex);
            return Optional.empty();
        }
    }

    private static <T> T tokenizeFilePath(String separator, String rawValue, Function<Stream<String>, T> mapper) {
        String separatorRegex = Pattern.quote(separator);
        try (Scanner scanner = new Scanner(rawValue).useDelimiter(separatorRegex);){
            Stream<String> stream = scanner.tokens().map(String::trim).filter(Predicate.not(String::isBlank));
            T t = mapper.apply(stream);
            return t;
        }
    }
}

