/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources;

import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class SourceGlobFilter {
    private final List<PathMatcher> includes;
    private final List<PathMatcher> excludes;

    public SourceGlobFilter() {
        this(List.of(), List.of());
    }

    public SourceGlobFilter(List<String> includes, List<String> excludes) {
        this.includes = SourceGlobFilter.compileMatchers(includes);
        this.excludes = SourceGlobFilter.compileMatchers(excludes);
    }

    public boolean matches(Path relativeRoot, Path file) {
        boolean notIncluded;
        Path relativeFile = relativeRoot.relativize(file);
        boolean excluded = !this.excludes.isEmpty() && this.excludes.stream().anyMatch(SourceGlobFilter.checking(relativeFile));
        boolean bl = notIncluded = !this.includes.isEmpty() && this.includes.stream().noneMatch(SourceGlobFilter.checking(relativeFile));
        if (excluded || notIncluded) {
            return false;
        }
        return Files.isRegularFile(file, new LinkOption[0]) && FileUtils.getFileExtension(file).filter(".proto"::equalsIgnoreCase).isPresent();
    }

    private static List<PathMatcher> compileMatchers(List<String> patterns) {
        return patterns.stream().map("glob:"::concat).map(FileSystems.getDefault()::getPathMatcher).collect(Collectors.toUnmodifiableList());
    }

    private static Predicate<PathMatcher> checking(Path path) {
        return matcher -> matcher.matches(path);
    }
}

