/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static Path normalize(Path path) {
        return path.normalize().toAbsolutePath();
    }

    public static String getFileNameWithoutExtension(Path path) {
        String fileName = path.getFileName().toString();
        int lastDotIndex = fileName.lastIndexOf(46);
        return lastDotIndex <= 0 ? fileName : fileName.substring(0, lastDotIndex);
    }

    public static Optional<String> getFileExtension(Path path) {
        String fileName = path.getFileName().toString();
        int lastDotIndex = fileName.lastIndexOf(46);
        return lastDotIndex <= 0 ? Optional.empty() : Optional.of(fileName.substring(lastDotIndex));
    }

    public static FileSystem openZipAsFileSystem(Path zipPath) throws IOException {
        try {
            log.trace("Opening a new NIO virtual file system for {}", (Object)zipPath);
            return FileSystemProvider.installedProviders().stream().filter(provider -> provider.getScheme().equalsIgnoreCase("jar")).peek(provider -> log.trace("Found JAR file system provider at {}", provider)).findFirst().orElseThrow(FileSystemNotFoundException::new).newFileSystem(zipPath, Map.of());
        }
        catch (Exception ex) {
            throw new IOException("Failed to open " + String.valueOf(zipPath) + " as a valid ZIP/JAR archive", ex);
        }
    }

    public static void makeExecutable(Path file) throws IOException {
        try {
            log.trace("Ensuring {} is executable", (Object)file);
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(file, new LinkOption[0]));
            perms.add(PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(file, perms);
        }
        catch (UnsupportedOperationException ex) {
            log.trace("File system does not support setting POSIX file permissions");
        }
    }

    public static List<Path> rebaseFileTree(Path existingRoot, Path newRoot, Stream<Path> paths) throws IOException {
        Iterator iter = paths.iterator();
        ArrayList<Path> newPaths = new ArrayList<Path>();
        while (iter.hasNext()) {
            Path existingPath = (Path)iter.next();
            Path newPath = newRoot;
            for (Path part : existingRoot.relativize(existingPath)) {
                newPath = newPath.resolve(part.toString());
            }
            log.trace("copying {} to {} (existing root={}, new root={})", new Object[]{existingPath, newPath, existingRoot, newRoot});
            Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
            Files.copy(existingPath, newPath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            if (Files.isDirectory(newPath, new LinkOption[0])) continue;
            newPaths.add(newPath);
        }
        return Collections.unmodifiableList(newPaths);
    }
}

