/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources.incremental;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.github.ascopes.protobufmavenplugin.sources.ProjectInputListing;
import io.github.ascopes.protobufmavenplugin.sources.SourceListing;
import io.github.ascopes.protobufmavenplugin.sources.incremental.ImmutableSerializedIncrementalCache;
import io.github.ascopes.protobufmavenplugin.sources.incremental.SerializedIncrementalCache;
import io.github.ascopes.protobufmavenplugin.sources.incremental.SerializedIncrementalCacheModule;
import io.github.ascopes.protobufmavenplugin.utils.ConcurrentExecutor;
import io.github.ascopes.protobufmavenplugin.utils.Digests;
import io.github.ascopes.protobufmavenplugin.utils.TemporarySpace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.FutureTask;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class IncrementalCacheManager {
    private static final String SPEC_VERSION = "1.0";
    private static final Logger log = LoggerFactory.getLogger(IncrementalCacheManager.class);
    private final ConcurrentExecutor concurrentExecutor;
    private final TemporarySpace temporarySpace;
    private final ObjectMapper objectMapper;

    @Inject
    public IncrementalCacheManager(ConcurrentExecutor concurrentExecutor, TemporarySpace temporarySpace) {
        this.concurrentExecutor = concurrentExecutor;
        this.temporarySpace = temporarySpace;
        this.objectMapper = new JsonMapper().configure(SerializationFeature.INDENT_OUTPUT, true).registerModule((Module)new SerializedIncrementalCacheModule());
    }

    public void updateIncrementalCache() throws IOException {
        Path previousCache = this.getPreviousIncrementalCachePath();
        Path nextCache = this.getNextIncrementalCachePath();
        if (Files.exists(nextCache, new LinkOption[0])) {
            log.debug("Overwriting incremental build cache at {} with {}", (Object)previousCache, (Object)nextCache);
            Files.move(nextCache, previousCache, StandardCopyOption.REPLACE_EXISTING);
        } else {
            log.debug("No new incremental cache was created, so nothing will be updated...");
        }
    }

    public Collection<Path> determineSourcesToCompile(ProjectInputListing listing) throws IOException {
        boolean filesDeletedSinceLastBuild;
        SerializedIncrementalCache nextBuildCache = this.buildIncrementalCache(listing);
        this.writeIncrementalCache(this.getNextIncrementalCachePath(), nextBuildCache);
        Optional<SerializedIncrementalCache> maybePreviousBuildCache = this.readIncrementalCache(this.getPreviousIncrementalCachePath());
        if (maybePreviousBuildCache.isEmpty()) {
            log.info("All sources will be compiled, as no previous build data was detected");
            return SourceListing.flattenSourceProtoFiles(listing.getCompilableSources());
        }
        SerializedIncrementalCache previousBuildCache = maybePreviousBuildCache.get();
        if (!previousBuildCache.getDependencies().equals(nextBuildCache.getDependencies())) {
            log.info("Detected a change in dependencies, all sources will be recompiled");
            return SourceListing.flattenSourceProtoFiles(listing.getCompilableSources());
        }
        boolean bl = filesDeletedSinceLastBuild = !previousBuildCache.getSources().keySet().stream().allMatch(nextBuildCache.getSources().keySet()::contains);
        if (filesDeletedSinceLastBuild) {
            log.info("Detected that source files have been deleted, all sources will be recompiled");
            return SourceListing.flattenSourceProtoFiles(listing.getCompilableSources());
        }
        return nextBuildCache.getSources().keySet().stream().filter(this.isSourceFileDifferent(previousBuildCache, nextBuildCache)).collect(Collectors.toUnmodifiableSet());
    }

    private Predicate<Path> isSourceFileDifferent(SerializedIncrementalCache previousBuildCache, SerializedIncrementalCache nextBuildCache) {
        return file -> !Objects.equals(previousBuildCache.getSources().get(file), nextBuildCache.getSources().get(file));
    }

    private Optional<SerializedIncrementalCache> readIncrementalCache(Path path) throws IOException {
        Optional<SerializedIncrementalCache> optional;
        block8: {
            log.debug("Reading incremental cache in from {}", (Object)path);
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                optional = Optional.of((SerializedIncrementalCache)this.objectMapper.readValue(inputStream, SerializedIncrementalCache.class));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException ex) {
                    log.debug("No file found at {}", (Object)path);
                    return Optional.empty();
                }
            }
            inputStream.close();
        }
        return optional;
    }

    private void writeIncrementalCache(Path path, SerializedIncrementalCache cache) throws IOException {
        log.debug("Writing incremental cache out to {}", (Object)path);
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            this.objectMapper.writeValue(outputStream, (Object)cache);
        }
    }

    private SerializedIncrementalCache buildIncrementalCache(ProjectInputListing listing) {
        Iterator results = Stream.of(listing.getDependencySources(), listing.getCompilableSources()).map(this::createSerializedFileDigestsAsync).collect(this.concurrentExecutor.awaiting()).iterator();
        return ImmutableSerializedIncrementalCache.builder().dependencies((Map)results.next()).sources((Map)results.next()).build();
    }

    private FutureTask<Map<Path, String>> createSerializedFileDigestsAsync(Collection<SourceListing> listings) {
        return this.concurrentExecutor.submit(() -> listings.stream().map(SourceListing::getSourceProtoFiles).flatMap(Collection::stream).map(this::createSerializedFileDigestAsync).collect(this.concurrentExecutor.awaiting()).stream().collect(Collectors.toMap(rec$ -> ((CacheEntry)rec$).getPath(), rec$ -> ((CacheEntry)rec$).getDigest())));
    }

    private FutureTask<CacheEntry> createSerializedFileDigestAsync(Path file) {
        return this.concurrentExecutor.submit(() -> {
            log.trace("Generating digest for {}", (Object)file);
            try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
                String digest = Digests.sha512ForStream(inputStream);
                CacheEntry cacheEntry = new CacheEntry(file, digest);
                return cacheEntry;
            }
        });
    }

    private Path getIncrementalCacheRoot() {
        return this.temporarySpace.createTemporarySpace("incremental-build-cache", SPEC_VERSION);
    }

    private Path getPreviousIncrementalCachePath() {
        return this.getIncrementalCacheRoot().resolve("previous.json");
    }

    private Path getNextIncrementalCachePath() {
        return this.getIncrementalCacheRoot().resolve("next.json");
    }

    private static final class CacheEntry {
        private final Path path;
        private final String digest;

        private CacheEntry(Path path, String digest) {
            this.path = path;
            this.digest = digest;
        }

        private Path getPath() {
            return this.path;
        }

        private String getDigest() {
            return this.digest;
        }
    }
}

