/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import io.github.ascopes.protobufmavenplugin.utils.MultipleFailuresException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public final class ConcurrentExecutor {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentExecutor.class);
    final ExecutorService executorService;

    @Inject
    public ConcurrentExecutor() {
        ExecutorService executorService;
        try {
            log.debug("Trying to create new Loom virtual thread pool");
            executorService = (ExecutorService)Executors.class.getMethod("newVirtualThreadPerTaskExecutor", new Class[0]).invoke(null, new Object[0]);
            log.debug("Loom virtual thread pool creation was successful!");
        }
        catch (Exception ex) {
            ThreadGroup threadGroup = new ThreadGroup(this.getClass().getName());
            executorService = Executors.newCachedThreadPool(runnable -> {
                Thread thread = new Thread(threadGroup, runnable);
                thread.setDaemon(true);
                return thread;
            });
            log.debug("Falling back to new cached thread pool (group={}, reason={}: {})", new Object[]{threadGroup, ex.getClass().getName(), ex.getMessage()});
        }
        this.executorService = executorService;
    }

    @PreDestroy
    public void destroy() {
        log.debug("Shutting down executor...");
        List<Runnable> remainingTasks = this.executorService.shutdownNow();
        log.debug("Remaining tasks that will be orphaned: {}", remainingTasks);
    }

    public <R> FutureTask<R> submit(Callable<R> task) {
        FutureTask<R> futureTask = new FutureTask<R>(task);
        this.executorService.submit(futureTask);
        return futureTask;
    }

    public <R> Collector<FutureTask<R>, ?, List<R>> awaiting() {
        return Collectors.collectingAndThen(Collectors.toUnmodifiableList(), this::await);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> List<R> await(List<FutureTask<R>> scheduledTasks) {
        try {
            ArrayList<R> results = new ArrayList<R>();
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            for (FutureTask<R> task : scheduledTasks) {
                try {
                    results.add(task.get());
                }
                catch (ExecutionException ex) {
                    exceptions.add(ex.getCause());
                }
                catch (InterruptedException ex) {
                    exceptions.add(ex);
                    break;
                }
            }
            if (!exceptions.isEmpty()) {
                throw MultipleFailuresException.create(exceptions);
            }
            List list = Collections.unmodifiableList(results);
            return list;
        }
        finally {
            for (FutureTask<R> task : scheduledTasks) {
                task.cancel(true);
            }
        }
    }
}

