/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.protoc;

import io.github.ascopes.protobufmavenplugin.utils.ArgumentFileBuilder;
import io.github.ascopes.protobufmavenplugin.utils.TeeWriter;
import io.github.ascopes.protobufmavenplugin.utils.TemporarySpace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class CommandLineExecutor {
    private static final Logger log = LoggerFactory.getLogger(CommandLineExecutor.class);
    private final TemporarySpace temporarySpace;

    @Inject
    public CommandLineExecutor(TemporarySpace temporarySpace) {
        this.temporarySpace = temporarySpace;
    }

    public boolean execute(Path protocPath, ArgumentFileBuilder argumentFileBuilder) throws IOException {
        Path argumentFile = this.writeArgumentFile(argumentFileBuilder);
        log.info("Invoking protoc");
        log.debug("Protoc binary is located at {}", (Object)protocPath);
        ProcessBuilder procBuilder = new ProcessBuilder(protocPath.toString(), "@" + String.valueOf(argumentFile));
        procBuilder.environment().putAll(System.getenv());
        try {
            return this.runProcess(procBuilder);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            InterruptedIOException newEx = new InterruptedIOException("Execution was interrupted");
            newEx.initCause(ex);
            throw newEx;
        }
    }

    private boolean runProcess(ProcessBuilder procBuilder) throws InterruptedException, IOException {
        long startTimeNs = System.nanoTime();
        Process proc = procBuilder.start();
        Thread stdoutThread = this.redirectOutput(proc.getInputStream(), arg_0 -> ((Logger)log).info(arg_0));
        Thread stderrThread = this.redirectOutput(proc.getErrorStream(), arg_0 -> ((Logger)log).warn(arg_0));
        int exitCode = proc.waitFor();
        long elapsedTimeMs = (System.nanoTime() - startTimeNs) / 1000000L;
        stdoutThread.join();
        stderrThread.join();
        if (exitCode == 0) {
            log.info("protoc returned exit code 0 (success) after {}ms", (Object)elapsedTimeMs);
            return true;
        }
        log.error("protoc returned exit code {} (error) after {}ms", (Object)exitCode, (Object)elapsedTimeMs);
        return false;
    }

    private Thread redirectOutput(InputStream stream, Consumer<String> logger) {
        Thread thread = new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    logger.accept(line.stripTrailing());
                }
            }
            catch (IOException ex) {
                log.error("Stream error, output will be discarded", (Throwable)ex);
            }
        });
        thread.setDaemon(true);
        thread.setName("protoc output redirector thread for " + String.valueOf(stream));
        thread.start();
        return thread;
    }

    private Path writeArgumentFile(ArgumentFileBuilder argumentFileBuilder) throws IOException {
        TeeWriter writer;
        Path file = this.temporarySpace.createTemporarySpace("protoc").resolve("args.txt");
        log.debug("Writing to protoc argument file at {}", (Object)file);
        try (TeeWriter teeWriter = writer = new TeeWriter(Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]));){
            argumentFileBuilder.writeToProtocArgumentFile(writer);
        }
        log.debug("Written arguments were:\n{}", (Object)writer);
        return file;
    }
}

