/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependencies.aether;

import io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.WildcardAwareDependencyTraverser;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AetherArtifactMapper {
    private static final String DEFAULT_EXTENSION = "jar";
    private static final String DEFAULT_SCOPE = "compile";
    private static final Logger log = LoggerFactory.getLogger(AetherArtifactMapper.class);
    private final ArtifactHandler artifactHandler;
    private final ArtifactTypeRegistry artifactTypeRegistry;

    AetherArtifactMapper(ArtifactHandler artifactHandler, ArtifactTypeRegistry artifactTypeRegistry) {
        this.artifactHandler = artifactHandler;
        this.artifactTypeRegistry = artifactTypeRegistry;
    }

    ArtifactHandler getArtifactHandler() {
        return this.artifactHandler;
    }

    ArtifactTypeRegistry getArtifactTypeRegistry() {
        return this.artifactTypeRegistry;
    }

    Path mapEclipseArtifactToPath(Artifact eclipseArtifact) {
        File file = eclipseArtifact.getFile();
        return FileUtils.normalize(file.toPath());
    }

    Artifact mapPmpArtifactToEclipseArtifact(MavenArtifact mavenArtifact) {
        return new DefaultArtifact(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), this.classifierOrDefault(mavenArtifact.getClassifier()), this.extensionOrDefault(mavenArtifact.getType()), mavenArtifact.getVersion());
    }

    Dependency mapPmpArtifactToEclipseDependency(MavenArtifact mavenArtifact, DependencyResolutionDepth defaultDepth) {
        DependencyResolutionDepth effectiveDependencyResolutionDepth = Objects.requireNonNullElse(mavenArtifact.getDependencyResolutionDepth(), defaultDepth);
        List<Object> exclusions = effectiveDependencyResolutionDepth == DependencyResolutionDepth.DIRECT ? List.of(WildcardAwareDependencyTraverser.WILDCARD_EXCLUSION) : List.of();
        Artifact artifact = this.mapPmpArtifactToEclipseArtifact(mavenArtifact);
        return new Dependency(artifact, DEFAULT_SCOPE, Boolean.valueOf(false), exclusions);
    }

    Dependency mapMavenDependencyToEclipseDependency(org.apache.maven.model.Dependency mavenDependency) {
        DefaultArtifact artifact = new DefaultArtifact(mavenDependency.getGroupId(), mavenDependency.getArtifactId(), this.classifierOrDefault(mavenDependency.getClassifier()), null, mavenDependency.getVersion(), this.extensionToEclipseArtifactType(mavenDependency.getType()));
        List exclusions = mavenDependency.getExclusions().stream().map(mavenExclusion -> new Exclusion(mavenExclusion.getGroupId(), mavenExclusion.getArtifactId(), null, null)).collect(Collectors.toUnmodifiableList());
        return new Dependency((Artifact)artifact, mavenDependency.getScope(), Boolean.valueOf(mavenDependency.isOptional()), exclusions);
    }

    private @Nullable String classifierOrDefault(@Nullable String classifier) {
        if (classifier == null) {
            classifier = this.artifactHandler.getClassifier();
        }
        return classifier;
    }

    private @Nullable ArtifactType extensionToEclipseArtifactType(@Nullable String extension) {
        ArtifactType type = this.artifactTypeRegistry.get(extension = this.extensionOrDefault(extension));
        if (type == null) {
            log.debug("Could not resolve extension {} to any known Aether artifact type", (Object)extension);
        } else {
            log.debug("Resolved extension {} to Aether artifact type (classifier: {}, type: {}, id: {}, {})", new Object[]{extension, type.getClassifier(), type.getExtension(), type.getId(), type.getProperties()});
        }
        return type;
    }

    private String extensionOrDefault(@Nullable String extension) {
        if (extension == null) {
            extension = Objects.requireNonNullElse(this.artifactHandler.getExtension(), DEFAULT_EXTENSION);
        }
        return extension;
    }
}

