/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependencies.aether;

import io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifactPathResolver;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.AetherArtifactMapper;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.AetherResolver;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.ProtobufMavenPluginRepositorySession;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;

@Named
final class AetherMavenArtifactPathResolver
implements MavenArtifactPathResolver {
    private final MavenSession mavenSession;
    private final AetherArtifactMapper aetherMapper;
    private final AetherResolver aetherResolver;

    @Inject
    AetherMavenArtifactPathResolver(MavenSession mavenSession, RepositorySystem repositorySystem, ArtifactHandler artifactHandler) {
        List artifactRepositories = mavenSession.getProjectBuildingRequest().getRemoteRepositories();
        List remoteRepositories = RepositoryUtils.toRepos((List)artifactRepositories);
        this.mavenSession = mavenSession;
        ProtobufMavenPluginRepositorySession repositorySystemSession = new ProtobufMavenPluginRepositorySession(mavenSession.getRepositorySession());
        this.aetherMapper = new AetherArtifactMapper(artifactHandler, repositorySystemSession.getArtifactTypeRegistry());
        this.aetherResolver = new AetherResolver(repositorySystem, repositorySystemSession, remoteRepositories);
    }

    MavenSession getMavenSession() {
        return this.mavenSession;
    }

    AetherArtifactMapper getAetherMapper() {
        return this.aetherMapper;
    }

    AetherResolver getAetherResolver() {
        return this.aetherResolver;
    }

    @Override
    public Path resolveArtifact(MavenArtifact mavenArtifact) throws ResolutionException {
        Artifact unresolvedArtifact = this.aetherMapper.mapPmpArtifactToEclipseArtifact(mavenArtifact);
        Artifact resolvedArtifact = this.aetherResolver.resolveArtifact(unresolvedArtifact);
        return this.aetherMapper.mapEclipseArtifactToPath(resolvedArtifact);
    }

    @Override
    public List<Path> resolveDependencies(Collection<? extends MavenArtifact> artifacts, DependencyResolutionDepth defaultDepth, Set<String> dependencyScopes, boolean includeProjectDependencies, boolean failOnInvalidDependencies) throws ResolutionException {
        ArrayList<Dependency> unresolvedDependencies = new ArrayList<Dependency>();
        artifacts.stream().map(artifact -> this.aetherMapper.mapPmpArtifactToEclipseDependency((MavenArtifact)artifact, defaultDepth)).forEach(unresolvedDependencies::add);
        if (includeProjectDependencies) {
            this.mavenSession.getCurrentProject().getDependencies().stream().map(this.aetherMapper::mapMavenDependencyToEclipseDependency).forEach(unresolvedDependencies::add);
        }
        Collection<Artifact> resolvedArtifacts = this.aetherResolver.resolveDependenciesToArtifacts(unresolvedDependencies, dependencyScopes, failOnInvalidDependencies);
        return resolvedArtifacts.stream().map(this.aetherMapper::mapEclipseArtifactToPath).distinct().collect(Collectors.toUnmodifiableList());
    }
}

