/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.protoc;

import io.github.ascopes.protobufmavenplugin.generation.Language;
import io.github.ascopes.protobufmavenplugin.plugins.ResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.utils.ArgumentFileBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class ProtocArgumentFileBuilderBuilder {
    private boolean fatalWarnings = false;
    private final List<Path> importPaths = new ArrayList<Path>();
    private final List<Path> sourcePaths = new ArrayList<Path>();
    private final Set<Target> targets = new TreeSet<Target>();

    public ProtocArgumentFileBuilderBuilder addImportPaths(Collection<Path> importPaths) {
        this.importPaths.addAll(importPaths);
        return this;
    }

    public ProtocArgumentFileBuilderBuilder addLanguages(Collection<Language> languages, Path outputPath, boolean lite) {
        languages.stream().map(language -> new LanguageTarget((Language)((Object)language), outputPath, lite)).forEachOrdered(this.targets::add);
        return this;
    }

    public ProtocArgumentFileBuilderBuilder addPlugins(Collection<ResolvedProtocPlugin> plugins, Path outputPath) {
        plugins.stream().map(plugin -> new PluginTarget((ResolvedProtocPlugin)plugin, outputPath)).forEachOrdered(this.targets::add);
        return this;
    }

    public ProtocArgumentFileBuilderBuilder addSourcePaths(Collection<Path> sourcePaths) {
        this.sourcePaths.addAll(sourcePaths);
        return this;
    }

    public ProtocArgumentFileBuilderBuilder setFatalWarnings(boolean fatalWarnings) {
        this.fatalWarnings = fatalWarnings;
        return this;
    }

    public ProtocArgumentFileBuilderBuilder setOutputDescriptorFile(Path outputDescriptorFile, boolean includeImports, boolean includeSourceInfo, boolean retainOptions) {
        this.targets.add(new ProtoDescriptorTarget(outputDescriptorFile, includeImports, includeSourceInfo, retainOptions));
        return this;
    }

    public ArgumentFileBuilder build() {
        if (this.targets.isEmpty()) {
            throw new IllegalStateException("No output target operations were provided");
        }
        ArgumentFileBuilder argumentFileBuilder = new ArgumentFileBuilder();
        if (this.fatalWarnings) {
            argumentFileBuilder.add("--fatal_warnings");
        }
        for (Target target : this.targets) {
            target.addArgsTo(argumentFileBuilder);
        }
        for (Path sourcePath : this.sourcePaths) {
            argumentFileBuilder.add(sourcePath);
        }
        for (Path importPath : this.importPaths) {
            argumentFileBuilder.add("--proto_path=" + String.valueOf(importPath));
        }
        return argumentFileBuilder;
    }

    private static final class ProtoDescriptorTarget
    extends Target {
        private final Path outputDescriptorFile;
        private final boolean includeImports;
        private final boolean includeSourceInfo;
        private final boolean retainOptions;

        private ProtoDescriptorTarget(Path outputDescriptorFile, boolean includeImports, boolean includeSourceInfo, boolean retainOptions) {
            super("descriptor:" + String.valueOf(outputDescriptorFile));
            this.outputDescriptorFile = outputDescriptorFile;
            this.includeImports = includeImports;
            this.includeSourceInfo = includeSourceInfo;
            this.retainOptions = retainOptions;
        }

        @Override
        void addArgsTo(ArgumentFileBuilder argumentFileBuilder) {
            argumentFileBuilder.add("--descriptor_set_out=" + String.valueOf(this.outputDescriptorFile));
            if (this.includeImports) {
                argumentFileBuilder.add("--include_imports");
            }
            if (this.includeSourceInfo) {
                argumentFileBuilder.add("--include_source_info");
            }
            if (this.retainOptions) {
                argumentFileBuilder.add("--retain_options");
            }
        }

        @Override
        int getOrder() {
            return 0;
        }
    }

    private static abstract class Target
    implements Comparable<Target> {
        private final String key;

        Target(String key) {
            this.key = key;
        }

        abstract void addArgsTo(ArgumentFileBuilder var1);

        abstract int getOrder();

        @Override
        public final int compareTo(Target that) {
            return Comparator.comparingInt(Target::getOrder).thenComparing(target -> target.key).compare(this, that);
        }
    }

    private static final class PluginTarget
    extends Target {
        private final ResolvedProtocPlugin plugin;
        private final Path outputPath;

        private PluginTarget(ResolvedProtocPlugin plugin, Path outputPath) {
            super("plugin:" + String.valueOf(plugin) + ":" + String.valueOf(outputPath));
            this.plugin = plugin;
            this.outputPath = outputPath;
        }

        @Override
        public void addArgsTo(ArgumentFileBuilder argumentFileBuilder) {
            argumentFileBuilder.add("--plugin=protoc-gen-" + this.plugin.getId() + "=" + String.valueOf(this.plugin.getPath()));
            argumentFileBuilder.add("--" + this.plugin.getId() + "_out=" + String.valueOf(this.outputPath));
            this.plugin.getOptions().map(options -> "--" + this.plugin.getId() + "_opt=" + options).ifPresent(argumentFileBuilder::add);
        }

        @Override
        public int getOrder() {
            return this.plugin.getOrder();
        }
    }

    private static final class LanguageTarget
    extends Target {
        private final Language language;
        private final Path outputPath;
        private final boolean lite;

        private LanguageTarget(Language language, Path outputPath, boolean lite) {
            super("language:" + String.valueOf((Object)language));
            this.language = language;
            this.outputPath = outputPath;
            this.lite = lite;
        }

        @Override
        void addArgsTo(ArgumentFileBuilder argumentFileBuilder) {
            String flag = "--" + this.language.getFlagName() + "_out=" + (this.lite ? "lite:" : "") + String.valueOf(this.outputPath);
            argumentFileBuilder.add(flag);
        }

        @Override
        int getOrder() {
            return 0;
        }
    }
}

