/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.generation;

import io.github.ascopes.protobufmavenplugin.generation.GenerationRequest;
import io.github.ascopes.protobufmavenplugin.generation.GenerationResult;
import io.github.ascopes.protobufmavenplugin.generation.Language;
import io.github.ascopes.protobufmavenplugin.generation.SourceRootRegistrar;
import io.github.ascopes.protobufmavenplugin.plugins.ProjectPluginResolver;
import io.github.ascopes.protobufmavenplugin.plugins.ResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.protoc.ImmutableProtocInvocation;
import io.github.ascopes.protobufmavenplugin.protoc.ProtocExecutor;
import io.github.ascopes.protobufmavenplugin.protoc.ProtocInvocation;
import io.github.ascopes.protobufmavenplugin.protoc.ProtocResolver;
import io.github.ascopes.protobufmavenplugin.protoc.targets.ImmutableDescriptorFileProtocTarget;
import io.github.ascopes.protobufmavenplugin.protoc.targets.ImmutableLanguageProtocTarget;
import io.github.ascopes.protobufmavenplugin.protoc.targets.ImmutablePluginProtocTarget;
import io.github.ascopes.protobufmavenplugin.protoc.targets.ProtocTarget;
import io.github.ascopes.protobufmavenplugin.sources.DescriptorListing;
import io.github.ascopes.protobufmavenplugin.sources.FilesToCompile;
import io.github.ascopes.protobufmavenplugin.sources.ProjectInputListing;
import io.github.ascopes.protobufmavenplugin.sources.ProjectInputResolver;
import io.github.ascopes.protobufmavenplugin.sources.SourceListing;
import io.github.ascopes.protobufmavenplugin.sources.incremental.IncrementalCacheManager;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import io.github.ascopes.protobufmavenplugin.utils.StringUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Orchestrator for the entire generation process, gluing all components together")
@MojoExecutionScoped
@Named
public final class ProtobufBuildOrchestrator {
    private static final Logger log = LoggerFactory.getLogger(ProtobufBuildOrchestrator.class);
    private final MavenSession mavenSession;
    private final ProtocResolver protocResolver;
    private final ProjectInputResolver projectInputResolver;
    private final ProjectPluginResolver projectPluginResolver;
    private final IncrementalCacheManager incrementalCacheManager;
    private final ProtocExecutor protocExecutor;

    @Inject
    public ProtobufBuildOrchestrator(MavenSession mavenSession, ProtocResolver protocResolver, ProjectInputResolver projectInputResolver, ProjectPluginResolver projectPluginResolver, IncrementalCacheManager incrementalCacheManager, ProtocExecutor protocExecutor) {
        this.mavenSession = mavenSession;
        this.protocResolver = protocResolver;
        this.projectInputResolver = projectInputResolver;
        this.projectPluginResolver = projectPluginResolver;
        this.incrementalCacheManager = incrementalCacheManager;
        this.protocExecutor = protocExecutor;
    }

    public GenerationResult generate(GenerationRequest request) throws ResolutionException, IOException {
        log.debug("The provided protobuf GenerationRequest is: {}", (Object)request);
        if (request.getSourceDirectories().isEmpty() && request.getSourceDependencies().isEmpty() && request.getSourceDescriptorPaths().isEmpty() && request.getSourceDescriptorDependencies().isEmpty()) {
            return this.handleMissingInputs(request);
        }
        Path protocPath = this.discoverProtocPath(request);
        Collection<ResolvedProtocPlugin> resolvedPlugins = this.projectPluginResolver.resolveProjectPlugins(request);
        ProjectInputListing projectInputs = this.projectInputResolver.resolveProjectInputs(request);
        if (projectInputs.getCompilableProtoSources().isEmpty() && projectInputs.getCompilableDescriptorFiles().isEmpty()) {
            return this.handleMissingInputs(request);
        }
        if (resolvedPlugins.isEmpty() && request.getEnabledLanguages().isEmpty() && request.getOutputDescriptorFile() == null) {
            return this.handleMissingTargets(request);
        }
        this.createOutputDirectories(request);
        this.registerSourceRoots(request);
        FilesToCompile compilableFiles = this.computeFilesToCompile(request, projectInputs);
        if (compilableFiles.isEmpty()) {
            this.incrementalCacheManager.updateIncrementalCache();
            return GenerationResult.NOTHING_TO_DO;
        }
        ProtocInvocation invocation = this.createProtocInvocation(request, protocPath, resolvedPlugins, projectInputs, compilableFiles);
        if (!this.protocExecutor.invoke(invocation)) {
            return GenerationResult.PROTOC_FAILED;
        }
        this.incrementalCacheManager.updateIncrementalCache();
        if (request.getOutputDescriptorFile() != null && request.isOutputDescriptorAttached()) {
            request.getOutputDescriptorAttachmentRegistrar().registerAttachedArtifact(this.mavenSession, request.getOutputDescriptorFile(), request.getOutputDescriptorAttachmentType(), request.getOutputDescriptorAttachmentClassifier());
        }
        if (request.isEmbedSourcesInClassOutputs()) {
            this.embedSourcesInClassOutputs(request.getSourceRootRegistrar(), projectInputs.getCompilableProtoSources());
        }
        return GenerationResult.PROTOC_SUCCEEDED;
    }

    private GenerationResult handleMissingInputs(GenerationRequest request) {
        String message = "No protobuf sources found. If this is unexpected, check your configuration and try again.";
        if (request.isFailOnMissingSources()) {
            log.error("{}", (Object)message);
            return GenerationResult.NO_SOURCES;
        }
        log.warn("{}", (Object)message);
        return GenerationResult.NOTHING_TO_DO;
    }

    private GenerationResult handleMissingTargets(GenerationRequest request) {
        String message = "No output languages or descriptors are enabled and no plugins were found. If this is unexpected, check your configuration and try again.";
        if (request.isFailOnMissingTargets()) {
            log.error("{}", (Object)message);
            return GenerationResult.NO_TARGETS;
        }
        log.warn("{}", (Object)message);
        return GenerationResult.NOTHING_TO_DO;
    }

    private Path discoverProtocPath(GenerationRequest request) throws ResolutionException {
        return this.protocResolver.resolve(request.getProtocVersion()).orElseThrow(() -> new ResolutionException("Protoc binary was not found"));
    }

    private void createOutputDirectories(GenerationRequest request) throws IOException {
        Path directory = request.getOutputDirectory();
        log.debug("Creating {}", (Object)directory);
        FileUtils.getFileExtension(directory).filter(".jar"::equalsIgnoreCase).ifPresent(ext -> {
            throw new IllegalArgumentException("The output directory '" + String.valueOf(directory) + "' cannot be a path with a JAR file extension, due to limitations with how protoc operates on file names.");
        });
        Files.createDirectories(directory, new FileAttribute[0]);
        Optional.ofNullable(request.getOutputDescriptorFile()).map(p -> p.toAbsolutePath().getParent()).ifPresent(p -> {
            try {
                Files.createDirectories(p, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create output directory for descriptor file '" + String.valueOf(p) + "'", e);
            }
        });
    }

    private void registerSourceRoots(GenerationRequest request) {
        if (request.isRegisterAsCompilationRoot()) {
            request.getSourceRootRegistrar().registerSourceRoot(this.mavenSession, request.getOutputDirectory());
        }
    }

    private FilesToCompile computeFilesToCompile(GenerationRequest request, ProjectInputListing projectInputs) throws IOException {
        FilesToCompile filesToCompile;
        int totalSourceFileCount = projectInputs.getCompilableProtoSources().stream().mapToInt(sourcePath -> sourcePath.getSourceFiles().size()).sum();
        int totalDescriptorFileCount = projectInputs.getCompilableDescriptorFiles().stream().mapToInt(sourcePath -> sourcePath.getSourceFiles().size()).sum();
        FilesToCompile filesToCompile2 = filesToCompile = this.shouldIncrementallyCompile(request) ? this.incrementalCacheManager.determineSourcesToCompile(projectInputs) : FilesToCompile.allOf(projectInputs);
        if (filesToCompile.isEmpty()) {
            log.info("Found {} and {} to compile, but all are up-to-date so none will be built this time", (Object)StringUtils.pluralize(totalSourceFileCount, "proto source file"), (Object)StringUtils.pluralize(totalDescriptorFileCount, "descriptor file"));
            return FilesToCompile.empty();
        }
        log.info("Generating source code from {} and {} (discovered a total of {} and {})", new Object[]{StringUtils.pluralize(filesToCompile.getProtoSources().size(), "proto source file"), StringUtils.pluralize(filesToCompile.getDescriptorFiles().size(), "descriptor file"), StringUtils.pluralize(totalSourceFileCount, "proto source file"), StringUtils.pluralize(totalDescriptorFileCount, "descriptor file")});
        return filesToCompile;
    }

    private boolean shouldIncrementallyCompile(GenerationRequest request) {
        if (!request.isIncrementalCompilationEnabled()) {
            log.debug("Incremental compilation is disabled");
            return false;
        }
        if (request.getOutputDescriptorFile() != null) {
            log.info("Incremental compilation is disabled since proto descriptor generation has been requested.");
            return false;
        }
        log.debug("Will use incremental compilation");
        return true;
    }

    private void embedSourcesInClassOutputs(SourceRootRegistrar registrar, Collection<SourceListing> listings) throws ResolutionException {
        for (SourceListing listing : listings) {
            try {
                registrar.embedListing(this.mavenSession, listing);
            }
            catch (IOException ex) {
                throw new ResolutionException("Failed to embed " + String.valueOf(listing.getSourceRoot()) + " into the class outputs directory", ex);
            }
        }
    }

    private ProtocInvocation createProtocInvocation(GenerationRequest request, Path protocPath, Collection<ResolvedProtocPlugin> resolvedPlugins, ProjectInputListing projectInputs, FilesToCompile filesToCompile) {
        TreeSet<ProtocTarget> targets = new TreeSet<ProtocTarget>();
        request.getEnabledLanguages().stream().map(language -> ImmutableLanguageProtocTarget.builder().isLite(request.isLiteEnabled()).language((Language)((Object)language)).outputPath(request.getOutputDirectory()).build()).forEach(targets::add);
        resolvedPlugins.stream().map(plugin -> ImmutablePluginProtocTarget.builder().plugin((ResolvedProtocPlugin)plugin).outputPath(request.getOutputDirectory()).build()).forEach(targets::add);
        if (request.getOutputDescriptorFile() != null) {
            ImmutableDescriptorFileProtocTarget descriptorFileTarget = ImmutableDescriptorFileProtocTarget.builder().isIncludeImports(request.isOutputDescriptorIncludeImports()).isIncludeSourceInfo(request.isOutputDescriptorIncludeSourceInfo()).isRetainOptions(request.isOutputDescriptorRetainOptions()).outputFile(request.getOutputDescriptorFile()).build();
            targets.add(descriptorFileTarget);
        }
        List importPaths = Stream.of(projectInputs.getCompilableProtoSources(), projectInputs.getDependencyProtoSources()).flatMap(Collection::stream).map(SourceListing::getSourceRoot).collect(Collectors.toUnmodifiableList());
        List inputDescriptorFiles = projectInputs.getCompilableDescriptorFiles().stream().map(DescriptorListing::getDescriptorFilePath).collect(Collectors.toUnmodifiableList());
        return ImmutableProtocInvocation.builder().descriptorSourceFiles(filesToCompile.getDescriptorFiles()).importPaths(importPaths).inputDescriptorFiles(inputDescriptorFiles).isFatalWarnings(request.isFatalWarnings()).protocPath(protocPath).sourcePaths(filesToCompile.getProtoSources()).targets(targets).build();
    }
}

