/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Scanner;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.sisu.Description;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Discovers information about the platform that the plugin is being invoked on")
@MojoExecutionScoped
@Named
public final class HostSystem {
    private static final Logger log = LoggerFactory.getLogger(HostSystem.class);
    private final String operatingSystem;
    private final String cpuArchitecture;
    private final String pathSeparator;
    private final Path javaHome;
    private final String javaVendor;
    private final List<Path> path;
    private final SortedSet<String> pathExt;

    @Inject
    public HostSystem() {
        this(HostSystem.optionalFunction(System::getProperty), HostSystem.optionalFunction(System::getenv));
    }

    HostSystem(Function<String, Optional<String>> propertyProvider, Function<String, Optional<String>> envProvider) {
        this.operatingSystem = propertyProvider.apply("os.name").orElse("");
        log.debug("Reported OS: '{}'", (Object)this.operatingSystem);
        this.cpuArchitecture = propertyProvider.apply("os.arch").orElse("");
        log.debug("Reported CPU: '{}'", (Object)this.cpuArchitecture);
        this.pathSeparator = propertyProvider.apply("path.separator").orElse(":");
        log.debug("Reported path separator: '{}'", (Object)this.pathSeparator);
        this.javaHome = propertyProvider.apply("java.home").map(x$0 -> Path.of(x$0, new String[0])).map(FileUtils::normalize).orElseGet(() -> FileUtils.normalize(Path.of("", new String[0])));
        log.debug("Reported java.home: '{}'", (Object)this.javaHome);
        this.javaVendor = propertyProvider.apply("java.vendor").orElse("");
        log.debug("Reported java.vendor: '{}'", (Object)this.javaVendor);
        this.path = envProvider.apply("PATH").map(value -> HostSystem.parsePath(value, this.pathSeparator)).orElseGet(Collections::emptyList);
        log.debug("Parsed system path: {}", this.path);
        this.pathExt = envProvider.apply("PATHEXT").map(value -> HostSystem.parsePathExt(value, this.pathSeparator)).orElseGet(Collections::emptySortedSet);
        log.debug("Parsed path extensions: {}", this.pathExt);
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getCpuArchitecture() {
        return this.cpuArchitecture;
    }

    public boolean isProbablyLinux() {
        return this.operatingSystem.toLowerCase(Locale.ROOT).startsWith("linux");
    }

    public boolean isProbablyTermux() {
        return this.javaVendor.equalsIgnoreCase("termux");
    }

    public boolean isProbablyMacOs() {
        return this.operatingSystem.toLowerCase(Locale.ROOT).startsWith("mac os");
    }

    public boolean isProbablyWindows() {
        return this.operatingSystem.toLowerCase(Locale.ROOT).startsWith("windows");
    }

    public Path getJavaExecutablePath() {
        String executableName = this.isProbablyWindows() ? "java.exe" : "java";
        return this.javaHome.resolve("bin").resolve(executableName);
    }

    public List<Path> getSystemPath() {
        return this.path;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public SortedSet<String> getSystemPathExtensions() {
        return this.pathExt;
    }

    private static List<Path> parsePath(String rawPath, String pathSeparator) {
        return HostSystem.tokenizeFilePath(rawPath, pathSeparator, paths -> paths.flatMap(HostSystem.tryParseSystemFilePath()).distinct().filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toUnmodifiableList()));
    }

    private static SortedSet<String> parsePathExt(String rawPathExt, String pathSeparator) {
        return HostSystem.tokenizeFilePath(rawPathExt, pathSeparator, extensions -> extensions.map(String::toLowerCase).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet(String::compareToIgnoreCase)), Collections::unmodifiableSortedSet)));
    }

    private static <T> T tokenizeFilePath(String rawValue, String separator, Function<Stream<String>, T> mapper) {
        String separatorRegex = Pattern.quote(separator);
        try (Scanner scanner = new Scanner(rawValue).useDelimiter(separatorRegex);){
            Stream<String> stream = scanner.tokens().map(String::trim).filter(Predicate.not(String::isBlank));
            T t = mapper.apply(stream);
            return t;
        }
    }

    private static Function<String, Stream<Path>> tryParseSystemFilePath() {
        return path -> Stream.of(path).map(String::trim).filter(Predicate.not(String::isBlank)).flatMap(trimmedPath -> {
            try {
                return Stream.of(Path.of(trimmedPath, new String[0]));
            }
            catch (InvalidPathException ex) {
                log.warn("Ignoring path {} in $PATH environment variable. Please check your system settings!", trimmedPath, (Object)ex);
                return Stream.empty();
            }
        }).map(FileUtils::normalize);
    }

    private static <A, R> Function<A, Optional<R>> optionalFunction(Function<A, @Nullable R> fn) {
        return fn.andThen(Optional::ofNullable);
    }
}

