/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.urls;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

abstract class AbstractNestingUrlConnection
extends URLConnection {
    private final URL nestedUrl;
    private @Nullable URLConnection nestedConnection;
    private @Nullable InputStream nestedInputStream;

    AbstractNestingUrlConnection(URL url, URL nestedUrl) {
        super(url);
        this.nestedUrl = nestedUrl;
        this.setDoOutput(false);
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.nestedConnection = this.nestedUrl.openConnection();
        this.nestedConnection.setAllowUserInteraction(this.getAllowUserInteraction());
        this.nestedConnection.setConnectTimeout(this.getConnectTimeout());
        this.nestedConnection.setDoInput(this.getDoInput());
        this.nestedConnection.setIfModifiedSince(this.getIfModifiedSince());
        this.nestedConnection.setReadTimeout(this.getReadTimeout());
        this.nestedConnection.setUseCaches(this.getUseCaches());
        this.getRequestProperties().forEach((key, values) -> values.forEach(value -> this.nestedConnection.addRequestProperty((String)key, (String)value)));
        this.nestedConnection.setDoOutput(false);
        this.nestedConnection.connect();
        this.connected = true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.nestedInputStream == null) {
            Objects.requireNonNull(this.nestedConnection, "not connected");
            try {
                this.nestedInputStream = this.nestInputStream(this.nestedConnection.getInputStream());
            }
            catch (IOException ex) {
                this.nestedConnection.getInputStream().close();
                throw new IOException("Failed to wrap input stream with protocol " + this.url.getProtocol() + " for URL \"" + String.valueOf(this.url) + "\": " + String.valueOf(ex), ex);
            }
        }
        return this.nestedInputStream;
    }

    abstract InputStream nestInputStream(InputStream var1) throws IOException;
}

