/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources.incremental;

import io.github.ascopes.protobufmavenplugin.sources.incremental.IncrementalCache;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="IncrementalCache", generator="Immutables")
final class ImmutableIncrementalCache
implements IncrementalCache {
    private final Map<Path, String> protoDependencies;
    private final Map<Path, String> protoSources;
    private final Map<Path, String> descriptorFiles;

    private ImmutableIncrementalCache(Builder builder) {
        this.protoDependencies = builder.protoDependencies == null ? Collections.emptyMap() : ImmutableIncrementalCache.createUnmodifiableMap(false, false, builder.protoDependencies);
        this.protoSources = builder.protoSources == null ? Collections.emptyMap() : ImmutableIncrementalCache.createUnmodifiableMap(false, false, builder.protoSources);
        this.descriptorFiles = builder.descriptorFiles == null ? Collections.emptyMap() : ImmutableIncrementalCache.createUnmodifiableMap(false, false, builder.descriptorFiles);
    }

    @Override
    public Map<Path, String> getProtoDependencies() {
        return this.protoDependencies;
    }

    @Override
    public Map<Path, String> getProtoSources() {
        return this.protoSources;
    }

    @Override
    public Map<Path, String> getDescriptorFiles() {
        return this.descriptorFiles;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIncrementalCache && this.equalTo(0, (ImmutableIncrementalCache)another);
    }

    private boolean equalTo(int synthetic, ImmutableIncrementalCache another) {
        return this.protoDependencies.equals(another.protoDependencies) && this.protoSources.equals(another.protoSources) && this.descriptorFiles.equals(another.descriptorFiles);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.protoDependencies.hashCode();
        h += (h << 5) + this.protoSources.hashCode();
        h += (h << 5) + this.descriptorFiles.hashCode();
        return h;
    }

    public String toString() {
        return "IncrementalCache{protoDependencies=" + String.valueOf(this.protoDependencies) + ", protoSources=" + String.valueOf(this.protoSources) + ", descriptorFiles=" + String.valueOf(this.descriptorFiles) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="IncrementalCache", generator="Immutables")
    public static final class Builder {
        private Map<Path, String> protoDependencies = null;
        private Map<Path, String> protoSources = null;
        private Map<Path, String> descriptorFiles = null;

        private Builder() {
        }

        public final Builder from(IncrementalCache instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllProtoDependencies(instance.getProtoDependencies());
            this.putAllProtoSources(instance.getProtoSources());
            this.putAllDescriptorFiles(instance.getDescriptorFiles());
            return this;
        }

        public final Builder putProtoDependencies(Path key, String value) {
            if (this.protoDependencies == null) {
                this.protoDependencies = new LinkedHashMap<Path, String>();
            }
            this.protoDependencies.put(key, value);
            return this;
        }

        public final Builder putProtoDependencies(Map.Entry<? extends Path, ? extends String> entry) {
            if (this.protoDependencies == null) {
                this.protoDependencies = new LinkedHashMap<Path, String>();
            }
            Path k = entry.getKey();
            String v = entry.getValue();
            this.protoDependencies.put(k, v);
            return this;
        }

        public final Builder protoDependencies(Map<? extends Path, ? extends String> entries) {
            this.protoDependencies = new LinkedHashMap<Path, String>();
            return this.putAllProtoDependencies(entries);
        }

        public final Builder putAllProtoDependencies(Map<? extends Path, ? extends String> entries) {
            if (this.protoDependencies == null) {
                this.protoDependencies = new LinkedHashMap<Path, String>();
            }
            for (Map.Entry<? extends Path, ? extends String> e : entries.entrySet()) {
                Path k = e.getKey();
                String v = e.getValue();
                this.protoDependencies.put(k, v);
            }
            return this;
        }

        public final Builder putProtoSources(Path key, String value) {
            if (this.protoSources == null) {
                this.protoSources = new LinkedHashMap<Path, String>();
            }
            this.protoSources.put(key, value);
            return this;
        }

        public final Builder putProtoSources(Map.Entry<? extends Path, ? extends String> entry) {
            if (this.protoSources == null) {
                this.protoSources = new LinkedHashMap<Path, String>();
            }
            Path k = entry.getKey();
            String v = entry.getValue();
            this.protoSources.put(k, v);
            return this;
        }

        public final Builder protoSources(Map<? extends Path, ? extends String> entries) {
            this.protoSources = new LinkedHashMap<Path, String>();
            return this.putAllProtoSources(entries);
        }

        public final Builder putAllProtoSources(Map<? extends Path, ? extends String> entries) {
            if (this.protoSources == null) {
                this.protoSources = new LinkedHashMap<Path, String>();
            }
            for (Map.Entry<? extends Path, ? extends String> e : entries.entrySet()) {
                Path k = e.getKey();
                String v = e.getValue();
                this.protoSources.put(k, v);
            }
            return this;
        }

        public final Builder putDescriptorFiles(Path key, String value) {
            if (this.descriptorFiles == null) {
                this.descriptorFiles = new LinkedHashMap<Path, String>();
            }
            this.descriptorFiles.put(key, value);
            return this;
        }

        public final Builder putDescriptorFiles(Map.Entry<? extends Path, ? extends String> entry) {
            if (this.descriptorFiles == null) {
                this.descriptorFiles = new LinkedHashMap<Path, String>();
            }
            Path k = entry.getKey();
            String v = entry.getValue();
            this.descriptorFiles.put(k, v);
            return this;
        }

        public final Builder descriptorFiles(Map<? extends Path, ? extends String> entries) {
            this.descriptorFiles = new LinkedHashMap<Path, String>();
            return this.putAllDescriptorFiles(entries);
        }

        public final Builder putAllDescriptorFiles(Map<? extends Path, ? extends String> entries) {
            if (this.descriptorFiles == null) {
                this.descriptorFiles = new LinkedHashMap<Path, String>();
            }
            for (Map.Entry<? extends Path, ? extends String> e : entries.entrySet()) {
                Path k = e.getKey();
                String v = e.getValue();
                this.descriptorFiles.put(k, v);
            }
            return this;
        }

        public ImmutableIncrementalCache build() {
            return new ImmutableIncrementalCache(this);
        }
    }
}

