/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.fs;

import io.github.ascopes.protobufmavenplugin.fs.TemporarySpace;
import io.github.ascopes.protobufmavenplugin.utils.Digests;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.spi.URLStreamHandlerProvider;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Fetches and downloads resources from URIs")
@MojoExecutionScoped
@Named
public final class UriResourceFetcher {
    private static final List<String> OFFLINE_PROTOCOLS = List.of("file:", "jar:file:", "zip:file:", "jrt:");
    private static final int TIMEOUT = 30000;
    private static final Logger log = LoggerFactory.getLogger(UriResourceFetcher.class);
    private final MavenSession mavenSession;
    private final TemporarySpace temporarySpace;

    @Inject
    public UriResourceFetcher(MavenSession mavenSession, TemporarySpace temporarySpace) {
        this.mavenSession = mavenSession;
        this.temporarySpace = temporarySpace;
    }

    public Optional<Path> fetchFileFromUri(URI uri, String extension) throws ResolutionException {
        if (this.mavenSession.isOffline()) {
            boolean isInvalidOfflineProtocol = OFFLINE_PROTOCOLS.stream().noneMatch(uri.toString()::startsWith);
            if (isInvalidOfflineProtocol) {
                throw new ResolutionException("Cannot resolve URI: " + String.valueOf(uri) + ". Only a limited number of URL protocols are supported in offline mode.");
            }
        }
        return "file".equals(uri.getScheme()) ? this.handleFileSystemUri(uri) : this.handleOtherUri(uri, extension);
    }

    private Optional<Path> handleFileSystemUri(URI uri) throws ResolutionException {
        try {
            Optional<Path> result = Optional.of(uri).map(Path::of).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
            result.ifPresentOrElse(path -> log.debug("Resolved '{}' to '{}'", (Object)uri, path), () -> log.warn("No resource at '{}' appears to exist!", (Object)uri));
            return result;
        }
        catch (Exception ex) {
            throw new ResolutionException("Failed to discover file at '" + String.valueOf(uri) + "': " + String.valueOf(ex), ex);
        }
    }

    private Optional<Path> handleOtherUri(URI uri, String extension) throws ResolutionException {
        URL url = this.parseUrlWithAnyHandler(uri);
        Path targetFile = this.targetFile(url, extension);
        try {
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(30000);
            conn.setAllowUserInteraction(false);
            log.debug("Connecting to '{}' to copy resources to '{}'", (Object)uri, (Object)targetFile);
            conn.connect();
            try (BufferedInputStream responseStream = new BufferedInputStream(conn.getInputStream());
                 SizeAwareBufferedOutputStream fileStream = new SizeAwareBufferedOutputStream(Files.newOutputStream(targetFile, new OpenOption[0]));){
                responseStream.transferTo(fileStream);
                log.info("Downloaded '{}' to '{}' ({} bytes)", new Object[]{uri, targetFile, fileStream.size});
            }
            return Optional.of(targetFile);
        }
        catch (FileNotFoundException ex) {
            log.warn("No resource at '{}' appears to exist!", (Object)uri);
            return Optional.empty();
        }
        catch (IOException ex) {
            log.debug("Failed to download '{}' to '{}'", new Object[]{uri, targetFile, ex});
            throw new ResolutionException("Failed to download '" + String.valueOf(uri) + "' to '" + String.valueOf(targetFile) + "'", ex);
        }
    }

    private Path targetFile(URL url, String extension) {
        String digest = Digests.sha1(url.toExternalForm());
        String path = url.getPath();
        int lastSlash = path.lastIndexOf(47);
        String fileName = lastSlash < 0 ? digest : path.substring(lastSlash + 1) + "-" + digest;
        return this.temporarySpace.createTemporarySpace("url", url.getProtocol()).resolve(fileName + extension);
    }

    private URL parseUrlWithAnyHandler(URI uri) throws ResolutionException {
        URLStreamHandler customHandler = ServiceLoader.load(URLStreamHandlerProvider.class, this.getClass().getClassLoader()).stream().map(ServiceLoader.Provider::get).map(provider -> provider.createURLStreamHandler(uri.getScheme())).filter(Objects::nonNull).findFirst().orElse(null);
        log.debug("Parsing URI '{}' into URL using custom handler '{}'", (Object)uri, (Object)customHandler);
        try {
            return new URL(null, uri.toString(), customHandler);
        }
        catch (MalformedURLException ex) {
            throw new ResolutionException("URI '" + String.valueOf(uri) + "' is invalid: " + String.valueOf(ex), ex);
        }
    }

    private static final class SizeAwareBufferedOutputStream
    extends OutputStream {
        private final OutputStream delegate;
        private long size;

        private SizeAwareBufferedOutputStream(OutputStream delegate) {
            this.delegate = new BufferedOutputStream(delegate);
            this.size = 0L;
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.delegate.close();
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void write(int nextByte) throws IOException {
            ++this.size;
            this.delegate.write(nextByte);
        }
    }
}

