/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.protoc;

import io.github.ascopes.protobufmavenplugin.protoc.ProtocInvocation;
import io.github.ascopes.protobufmavenplugin.protoc.targets.ProtocTarget;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import org.immutables.value.Generated;

@Generated(from="ProtocInvocation", generator="Immutables")
public final class ImmutableProtocInvocation
implements ProtocInvocation {
    private final Path protocPath;
    private final boolean fatalWarnings;
    private final List<Path> importPaths;
    private final List<Path> inputDescriptorFiles;
    private final List<String> descriptorSourceFiles;
    private final List<Path> sourcePaths;
    private final SortedSet<ProtocTarget> targets;

    private ImmutableProtocInvocation(Builder builder) {
        this.protocPath = builder.protocPath;
        this.fatalWarnings = builder.fatalWarnings;
        this.importPaths = builder.importPaths == null ? Collections.emptyList() : ImmutableProtocInvocation.createUnmodifiableList(true, builder.importPaths);
        this.inputDescriptorFiles = builder.inputDescriptorFiles == null ? Collections.emptyList() : ImmutableProtocInvocation.createUnmodifiableList(true, builder.inputDescriptorFiles);
        this.descriptorSourceFiles = builder.descriptorSourceFiles == null ? Collections.emptyList() : ImmutableProtocInvocation.createUnmodifiableList(true, builder.descriptorSourceFiles);
        this.sourcePaths = builder.sourcePaths == null ? Collections.emptyList() : ImmutableProtocInvocation.createUnmodifiableList(true, builder.sourcePaths);
        this.targets = builder.targets;
    }

    @Override
    public Path getProtocPath() {
        return this.protocPath;
    }

    @Override
    public boolean isFatalWarnings() {
        return this.fatalWarnings;
    }

    @Override
    public List<Path> getImportPaths() {
        return this.importPaths;
    }

    @Override
    public List<Path> getInputDescriptorFiles() {
        return this.inputDescriptorFiles;
    }

    @Override
    public List<String> getDescriptorSourceFiles() {
        return this.descriptorSourceFiles;
    }

    @Override
    public List<Path> getSourcePaths() {
        return this.sourcePaths;
    }

    @Override
    public SortedSet<ProtocTarget> getTargets() {
        return this.targets;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProtocInvocation && this.equalTo(0, (ImmutableProtocInvocation)another);
    }

    private boolean equalTo(int synthetic, ImmutableProtocInvocation another) {
        return Objects.equals(this.protocPath, another.protocPath) && this.fatalWarnings == another.fatalWarnings && this.importPaths.equals(another.importPaths) && this.inputDescriptorFiles.equals(another.inputDescriptorFiles) && this.descriptorSourceFiles.equals(another.descriptorSourceFiles) && this.sourcePaths.equals(another.sourcePaths) && Objects.equals(this.targets, another.targets);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.protocPath);
        h += (h << 5) + Boolean.hashCode(this.fatalWarnings);
        h += (h << 5) + this.importPaths.hashCode();
        h += (h << 5) + this.inputDescriptorFiles.hashCode();
        h += (h << 5) + this.descriptorSourceFiles.hashCode();
        h += (h << 5) + this.sourcePaths.hashCode();
        h += (h << 5) + Objects.hashCode(this.targets);
        return h;
    }

    public String toString() {
        return "ProtocInvocation{protocPath=" + String.valueOf(this.protocPath) + ", fatalWarnings=" + this.fatalWarnings + ", importPaths=" + String.valueOf(this.importPaths) + ", inputDescriptorFiles=" + String.valueOf(this.inputDescriptorFiles) + ", descriptorSourceFiles=" + String.valueOf(this.descriptorSourceFiles) + ", sourcePaths=" + String.valueOf(this.sourcePaths) + ", targets=" + String.valueOf(this.targets) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ProtocInvocation", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PROTOC_PATH = 1L;
        private static final long INIT_BIT_FATAL_WARNINGS = 2L;
        private static final long INIT_BIT_TARGETS = 4L;
        private long initBits = 7L;
        private Path protocPath;
        private boolean fatalWarnings;
        private List<Path> importPaths = null;
        private List<Path> inputDescriptorFiles = null;
        private List<String> descriptorSourceFiles = null;
        private List<Path> sourcePaths = null;
        private SortedSet<ProtocTarget> targets;

        private Builder() {
        }

        public final Builder from(ProtocInvocation instance) {
            Objects.requireNonNull(instance, "instance");
            Path protocPathValue = instance.getProtocPath();
            if (protocPathValue != null) {
                this.protocPath(protocPathValue);
            }
            this.fatalWarnings(instance.isFatalWarnings());
            this.addAllImportPaths(instance.getImportPaths());
            this.addAllInputDescriptorFiles(instance.getInputDescriptorFiles());
            this.addAllDescriptorSourceFiles(instance.getDescriptorSourceFiles());
            this.addAllSourcePaths(instance.getSourcePaths());
            SortedSet<ProtocTarget> targetsValue = instance.getTargets();
            if (targetsValue != null) {
                this.targets(targetsValue);
            }
            return this;
        }

        public final Builder protocPath(Path protocPath) {
            this.protocPath = protocPath;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder fatalWarnings(boolean fatalWarnings) {
            this.fatalWarnings = fatalWarnings;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addImportPaths(Path element) {
            if (this.importPaths == null) {
                this.importPaths = new ArrayList<Path>();
            }
            this.importPaths.add(element);
            return this;
        }

        public final Builder addImportPaths(Path ... elements) {
            if (this.importPaths == null) {
                this.importPaths = new ArrayList<Path>();
            }
            for (Path element : elements) {
                this.importPaths.add(element);
            }
            return this;
        }

        public final Builder importPaths(Iterable<? extends Path> elements) {
            this.importPaths = new ArrayList<Path>();
            return this.addAllImportPaths(elements);
        }

        public final Builder addAllImportPaths(Iterable<? extends Path> elements) {
            Objects.requireNonNull(elements, "importPaths element");
            if (this.importPaths == null) {
                this.importPaths = new ArrayList<Path>();
            }
            for (Path path : elements) {
                this.importPaths.add(path);
            }
            return this;
        }

        public final Builder addInputDescriptorFiles(Path element) {
            if (this.inputDescriptorFiles == null) {
                this.inputDescriptorFiles = new ArrayList<Path>();
            }
            this.inputDescriptorFiles.add(element);
            return this;
        }

        public final Builder addInputDescriptorFiles(Path ... elements) {
            if (this.inputDescriptorFiles == null) {
                this.inputDescriptorFiles = new ArrayList<Path>();
            }
            for (Path element : elements) {
                this.inputDescriptorFiles.add(element);
            }
            return this;
        }

        public final Builder inputDescriptorFiles(Iterable<? extends Path> elements) {
            this.inputDescriptorFiles = new ArrayList<Path>();
            return this.addAllInputDescriptorFiles(elements);
        }

        public final Builder addAllInputDescriptorFiles(Iterable<? extends Path> elements) {
            Objects.requireNonNull(elements, "inputDescriptorFiles element");
            if (this.inputDescriptorFiles == null) {
                this.inputDescriptorFiles = new ArrayList<Path>();
            }
            for (Path path : elements) {
                this.inputDescriptorFiles.add(path);
            }
            return this;
        }

        public final Builder addDescriptorSourceFiles(String element) {
            if (this.descriptorSourceFiles == null) {
                this.descriptorSourceFiles = new ArrayList<String>();
            }
            this.descriptorSourceFiles.add(element);
            return this;
        }

        public final Builder addDescriptorSourceFiles(String ... elements) {
            if (this.descriptorSourceFiles == null) {
                this.descriptorSourceFiles = new ArrayList<String>();
            }
            for (String element : elements) {
                this.descriptorSourceFiles.add(element);
            }
            return this;
        }

        public final Builder descriptorSourceFiles(Iterable<String> elements) {
            this.descriptorSourceFiles = new ArrayList<String>();
            return this.addAllDescriptorSourceFiles(elements);
        }

        public final Builder addAllDescriptorSourceFiles(Iterable<String> elements) {
            Objects.requireNonNull(elements, "descriptorSourceFiles element");
            if (this.descriptorSourceFiles == null) {
                this.descriptorSourceFiles = new ArrayList<String>();
            }
            for (String element : elements) {
                this.descriptorSourceFiles.add(element);
            }
            return this;
        }

        public final Builder addSourcePaths(Path element) {
            if (this.sourcePaths == null) {
                this.sourcePaths = new ArrayList<Path>();
            }
            this.sourcePaths.add(element);
            return this;
        }

        public final Builder addSourcePaths(Path ... elements) {
            if (this.sourcePaths == null) {
                this.sourcePaths = new ArrayList<Path>();
            }
            for (Path element : elements) {
                this.sourcePaths.add(element);
            }
            return this;
        }

        public final Builder sourcePaths(Iterable<? extends Path> elements) {
            this.sourcePaths = new ArrayList<Path>();
            return this.addAllSourcePaths(elements);
        }

        public final Builder addAllSourcePaths(Iterable<? extends Path> elements) {
            Objects.requireNonNull(elements, "sourcePaths element");
            if (this.sourcePaths == null) {
                this.sourcePaths = new ArrayList<Path>();
            }
            for (Path path : elements) {
                this.sourcePaths.add(path);
            }
            return this;
        }

        public final Builder targets(SortedSet<ProtocTarget> targets) {
            this.targets = targets;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableProtocInvocation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProtocInvocation(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("protocPath");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fatalWarnings");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("targets");
            }
            return "Cannot build ProtocInvocation, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

