/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependencies.aether;

import io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenDependency;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenExclusion;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.FallbackEclipseArtifactType;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.ProtobufMavenPluginRepositorySession;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.WildcardAwareDependencyTraverser;
import io.github.ascopes.protobufmavenplugin.fs.FileUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Maps between various dependency and artifact types")
@MojoExecutionScoped
@Named
final class AetherArtifactMapper {
    private static final String DEFAULT_EXTENSION = "jar";
    private static final String DEFAULT_SCOPE = "compile";
    private static final Logger log = LoggerFactory.getLogger(AetherArtifactMapper.class);
    private final ArtifactTypeRegistry artifactTypeRegistry;

    @Inject
    AetherArtifactMapper(ProtobufMavenPluginRepositorySession protobufMavenPluginRepositorySession) {
        this.artifactTypeRegistry = protobufMavenPluginRepositorySession.getArtifactTypeRegistry();
    }

    Path mapEclipseArtifactToPath(Artifact eclipseArtifact) {
        File file = eclipseArtifact.getFile();
        return FileUtils.normalize(file.toPath());
    }

    Artifact mapPmpArtifactToEclipseArtifact(MavenArtifact mavenArtifact) {
        String extension = Objects.requireNonNullElse(mavenArtifact.getType(), DEFAULT_EXTENSION);
        ArtifactType artifactType = Optional.ofNullable(this.artifactTypeRegistry.get(extension)).orElseGet(() -> new FallbackEclipseArtifactType(extension));
        log.debug("Resolved extension {} to Aether artifact type (classifier: \"{}\", type: \"{}\", id: \"{}\", \"{}\")", new Object[]{mavenArtifact.getType(), artifactType.getClassifier(), artifactType.getExtension(), artifactType.getId(), artifactType.getProperties()});
        String classifier = Optional.ofNullable(mavenArtifact.getClassifier()).filter(Predicate.not(String::isBlank)).orElseGet(() -> ((ArtifactType)artifactType).getClassifier());
        return new DefaultArtifact(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), classifier, artifactType.getExtension(), mavenArtifact.getVersion());
    }

    Dependency mapPmpArtifactToEclipseDependency(MavenArtifact mavenArtifact, DependencyResolutionDepth defaultDepth) {
        DependencyResolutionDepth effectiveDependencyResolutionDepth = this.depth(mavenArtifact, defaultDepth);
        boolean isDirectDepth = DependencyResolutionDepth.DIRECT == effectiveDependencyResolutionDepth;
        Set<Exclusion> exclusions = isDirectDepth ? Set.of(WildcardAwareDependencyTraverser.WILDCARD_EXCLUSION) : this.mapPmpExclusionsToEclipseExclusions(this.pmpExclusions(mavenArtifact));
        return new Dependency(this.mapPmpArtifactToEclipseArtifact(mavenArtifact), DEFAULT_SCOPE, Boolean.valueOf(false), exclusions);
    }

    Artifact mapMavenArtifactToEclipseArtifact(org.apache.maven.artifact.Artifact mavenArtifact) {
        return RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)mavenArtifact);
    }

    Artifact mapMavenDependencyToEclipseArtifact(org.apache.maven.model.Dependency mavenDependency) {
        return RepositoryUtils.toDependency((org.apache.maven.model.Dependency)mavenDependency, (ArtifactTypeRegistry)this.artifactTypeRegistry).getArtifact();
    }

    private Set<Exclusion> mapPmpExclusionsToEclipseExclusions(Collection<? extends MavenExclusion> exclusions) {
        return exclusions.stream().map(exclusion -> new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), exclusion.getClassifier(), exclusion.getType())).collect(Collectors.toUnmodifiableSet());
    }

    private DependencyResolutionDepth depth(MavenArtifact mavenArtifact, DependencyResolutionDepth defaultDepth) {
        return this.asPmpMavenDependency(mavenArtifact).map(MavenDependency::getDependencyResolutionDepth).orElse(defaultDepth);
    }

    private Collection<? extends MavenExclusion> pmpExclusions(MavenArtifact mavenArtifact) {
        return this.asPmpMavenDependency(mavenArtifact).map(MavenDependency::getExclusions).orElseGet(Set::of);
    }

    private Optional<MavenDependency> asPmpMavenDependency(MavenArtifact mavenArtifact) {
        return Optional.of(mavenArtifact).filter(MavenDependency.class::isInstance).map(MavenDependency.class::cast);
    }
}

