/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources.filter;

import io.github.ascopes.protobufmavenplugin.sources.filter.FileFilter;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class IncludesExcludesGlobFilter
implements FileFilter {
    private final List<PathMatcher> includes;
    private final List<PathMatcher> excludes;

    public IncludesExcludesGlobFilter(List<String> includes, List<String> excludes) {
        this.includes = IncludesExcludesGlobFilter.compile(includes);
        this.excludes = IncludesExcludesGlobFilter.compile(excludes);
    }

    @Override
    public boolean matches(Path rootPath, Path filePath) {
        Path relativePath = rootPath.relativize(filePath);
        if (this.excludes.stream().anyMatch(IncludesExcludesGlobFilter.path(relativePath))) {
            return false;
        }
        return this.includes.isEmpty() || this.includes.stream().anyMatch(IncludesExcludesGlobFilter.path(relativePath));
    }

    private static List<PathMatcher> compile(List<String> globs) {
        return globs.stream().map("glob:"::concat).map(FileSystems.getDefault()::getPathMatcher).collect(Collectors.toUnmodifiableList());
    }

    private static Predicate<PathMatcher> path(Path path) {
        return pathMatcher -> pathMatcher.matches(path);
    }
}

