/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.protoc;

import io.github.ascopes.protobufmavenplugin.fs.TemporarySpace;
import io.github.ascopes.protobufmavenplugin.plugins.ResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.protoc.OutputRedirectorDaemon;
import io.github.ascopes.protobufmavenplugin.protoc.ProtocInvocation;
import io.github.ascopes.protobufmavenplugin.protoc.targets.DescriptorFileProtocTarget;
import io.github.ascopes.protobufmavenplugin.protoc.targets.LanguageProtocTarget;
import io.github.ascopes.protobufmavenplugin.protoc.targets.PluginProtocTarget;
import io.github.ascopes.protobufmavenplugin.protoc.targets.ProtocTarget;
import io.github.ascopes.protobufmavenplugin.utils.ArgumentFileBuilder;
import io.github.ascopes.protobufmavenplugin.utils.HostSystem;
import io.github.ascopes.protobufmavenplugin.utils.TeeWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Executes protoc in a subprocess, intercepting any outputs")
@MojoExecutionScoped
@Named
public final class ProtocExecutor {
    private static final Logger log = LoggerFactory.getLogger(ProtocExecutor.class);
    private final HostSystem hostSystem;
    private final TemporarySpace temporarySpace;

    @Inject
    public ProtocExecutor(HostSystem hostSystem, TemporarySpace temporarySpace) {
        this.hostSystem = hostSystem;
        this.temporarySpace = temporarySpace;
    }

    public boolean invoke(ProtocInvocation invocation) throws IOException {
        ArgumentFileBuilder argumentFileBuilder = this.createArgumentFileBuilder(invocation);
        Path argumentFile = this.writeArgumentFile(argumentFileBuilder);
        log.info("Invoking protoc (enable debug logs for more details)");
        log.debug("Protoc binary is located at \"{}\"", (Object)invocation.getProtocPath());
        log.debug("Protoc argument file:\n{}", (Object)argumentFileBuilder);
        ProcessBuilder procBuilder = new ProcessBuilder(invocation.getProtocPath().toString(), "@" + String.valueOf(argumentFile));
        Map<String, String> env = procBuilder.environment();
        env.putAll(System.getenv());
        env.putAll(invocation.getEnvironmentVariables());
        try {
            return this.runProcess(procBuilder);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            InterruptedIOException newEx = new InterruptedIOException("Execution was interrupted");
            newEx.initCause(ex);
            throw newEx;
        }
    }

    private ArgumentFileBuilder createArgumentFileBuilder(ProtocInvocation invocation) {
        return new ArgumentFileBuilder().applyForEach(invocation.getArguments(), ArgumentFileBuilder::add).addIfTrue(invocation.isFatalWarnings(), () -> "--fatal_warnings").applyForEach(invocation.getTargets(), this::applyProtocTargetArguments).addIfTrue(!invocation.getInputDescriptorFiles().isEmpty(), () -> this.createDescriptorInputArgument(invocation)).applyForEach(invocation.getSourcePaths(), this::applyProtoSourceFileArgument).applyForEach(invocation.getDescriptorSourceFiles(), this::applyDescriptorSourceArgument).applyForEach(invocation.getImportPaths(), this::applyImportPathArgument);
    }

    private void applyProtocTargetArguments(ArgumentFileBuilder builder, ProtocTarget target) {
        if (target instanceof DescriptorFileProtocTarget) {
            this.applyDescriptorFileProtocTargetArguments(builder, (DescriptorFileProtocTarget)target);
        } else if (target instanceof LanguageProtocTarget) {
            this.applyLanguageProtocTargetArguments(builder, (LanguageProtocTarget)target);
        } else if (target instanceof PluginProtocTarget) {
            this.applyPluginProtocTargetArguments(builder, (PluginProtocTarget)target);
        } else {
            throw new IllegalStateException("Unknown target " + String.valueOf(target));
        }
    }

    private void applyDescriptorFileProtocTargetArguments(ArgumentFileBuilder builder, DescriptorFileProtocTarget target) {
        builder.add("--descriptor_set_out=" + String.valueOf(target.getOutputFile())).addIfTrue(target.isIncludeImports(), () -> "--include_imports").addIfTrue(target.isIncludeSourceInfo(), () -> "--include_source_info").addIfTrue(target.isRetainOptions(), () -> "--retain_options");
    }

    private void applyLanguageProtocTargetArguments(ArgumentFileBuilder builder, LanguageProtocTarget target) {
        String flag = "--" + target.getLanguage().getFlagName() + "_out=" + (target.isLite() ? "lite:" : "") + String.valueOf(target.getOutputPath());
        builder.add(flag);
    }

    private void applyPluginProtocTargetArguments(ArgumentFileBuilder builder, PluginProtocTarget target) {
        ResolvedProtocPlugin plugin = target.getPlugin();
        builder.add("--plugin=protoc-gen-" + plugin.getId() + "=" + String.valueOf(plugin.getPath())).add("--" + plugin.getId() + "_out=" + String.valueOf(plugin.getOutputDirectory()));
        plugin.getOptions().map(options -> "--" + plugin.getId() + "_opt=" + options).ifPresent(builder::add);
    }

    private void applyImportPathArgument(ArgumentFileBuilder builder, Path path) {
        builder.add("--proto_path=" + String.valueOf(path));
    }

    private void applyProtoSourceFileArgument(ArgumentFileBuilder builder, Path file) {
        builder.add(file);
    }

    private void applyDescriptorSourceArgument(ArgumentFileBuilder builder, String file) {
        builder.add(file);
    }

    private String createDescriptorInputArgument(ProtocInvocation invocation) {
        return invocation.getInputDescriptorFiles().stream().map(Path::toString).collect(Collectors.joining(this.hostSystem.getPathSeparator(), "--descriptor_set_in=", ""));
    }

    private Path writeArgumentFile(ArgumentFileBuilder argumentFileBuilder) throws IOException {
        TeeWriter writer;
        Path file = this.temporarySpace.createTemporarySpace("protoc").resolve("args.txt");
        log.debug("Writing to protoc argument file at \"{}\"", (Object)file);
        try (TeeWriter teeWriter = writer = new TeeWriter(Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]));){
            argumentFileBuilder.writeToProtocArgumentFile(writer);
        }
        log.debug("Written arguments were:\n{}", (Object)writer);
        return file;
    }

    private boolean runProcess(ProcessBuilder procBuilder) throws InterruptedException, IOException {
        long startTimeNs = System.nanoTime();
        log.trace("Starting protoc subprocess");
        Process proc = procBuilder.start();
        OutputRedirectorDaemon stdoutRedirector = new OutputRedirectorDaemon("protoc - stdout", proc.pid(), proc.getInputStream(), (arg_0, arg_1) -> ((Logger)log).info(arg_0, arg_1));
        OutputRedirectorDaemon stderrRedirector = new OutputRedirectorDaemon("protoc - stderr", proc.pid(), proc.getErrorStream(), (arg_0, arg_1) -> ((Logger)log).warn(arg_0, arg_1));
        log.trace("Waiting for protoc to exit...");
        int exitCode = proc.waitFor();
        long elapsedTimeMs = (System.nanoTime() - startTimeNs) / 1000000L;
        log.trace("Waiting for stdout and stderr redirectors to terminate...");
        stdoutRedirector.await();
        stderrRedirector.await();
        log.trace("Stdout and stderr redirectors terminated");
        if (exitCode == 0) {
            log.info("protoc (pid {}) returned exit code 0 (success) after {}ms", (Object)proc.pid(), (Object)elapsedTimeMs);
            return true;
        }
        log.error("protoc (pid {}) returned exit code {} (error) after {}ms", new Object[]{proc.pid(), exitCode, elapsedTimeMs});
        return false;
    }
}

