/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.urls;

import io.github.ascopes.protobufmavenplugin.urls.AbstractNestingUrlConnection;
import io.github.ascopes.protobufmavenplugin.urls.AbstractUrlStreamHandlerFactory;
import io.github.ascopes.protobufmavenplugin.urls.HttpClientUrlConnection;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.http.HttpClient;

final class HttpUrlStreamHandlerFactory
extends AbstractUrlStreamHandlerFactory {
    private final HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).version(HttpClient.Version.HTTP_2).build();

    HttpUrlStreamHandlerFactory() {
        super("http", "https");
    }

    @Override
    URLConnection createUrlConnection(URL url) throws IOException {
        try {
            return new HttpClientUrlConnection(url, this.client);
        }
        catch (URISyntaxException uriException) {
            throw new AbstractNestingUrlConnection.NestedUrlException("Failed to create connection for URL " + String.valueOf(url), uriException);
        }
    }
}

