/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.plugins;

import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact;
import io.github.ascopes.protobufmavenplugin.plugins.MavenProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.MavenProtocPluginBean;
import io.github.ascopes.protobufmavenplugin.plugins.ProtocPlugin;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Generated(from="MavenProtocPlugin", generator="Immutables")
public final class ImmutableMavenProtocPlugin
extends MavenProtocPlugin {
    private final @Nullable String options;
    private final @Nullable Path outputDirectory;
    private final @Nullable Boolean registerAsCompilationRoot;
    private final int order;
    private final boolean skip;
    private final @Nullable String groupId;
    private final @Nullable String artifactId;
    private final @Nullable String type;
    private final @Nullable String classifier;
    private final @NonNull @Nullable String version;
    private final @Nullable List<String> jvmArgs;
    private final @Nullable List<String> jvmConfigArgs;
    private final @Nullable String mainClass;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMavenProtocPlugin(Builder builder) {
        this.options = builder.options;
        this.outputDirectory = builder.outputDirectory;
        this.registerAsCompilationRoot = builder.registerAsCompilationRoot;
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
        this.type = builder.type;
        this.classifier = builder.classifier;
        this.version = builder.version;
        this.jvmArgs = builder.jvmArgs == null ? null : ImmutableMavenProtocPlugin.createUnmodifiableList(true, builder.jvmArgs);
        this.jvmConfigArgs = builder.jvmConfigArgs == null ? null : ImmutableMavenProtocPlugin.createUnmodifiableList(true, builder.jvmConfigArgs);
        this.mainClass = builder.mainClass;
        if (builder.orderIsSet()) {
            this.initShim.order(builder.order);
        }
        if (builder.skipIsSet()) {
            this.initShim.skip(builder.skip);
        }
        this.order = this.initShim.getOrder();
        this.skip = this.initShim.isSkip();
        this.initShim = null;
    }

    @Override
    public @Nullable String getOptions() {
        return this.options;
    }

    @Override
    public @Nullable Path getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public @Nullable Boolean isRegisterAsCompilationRoot() {
        return this.registerAsCompilationRoot;
    }

    @Override
    public int getOrder() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOrder() : this.order;
    }

    @Override
    public boolean isSkip() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isSkip() : this.skip;
    }

    @Override
    public @Nullable String getGroupId() {
        return this.groupId;
    }

    @Override
    public @Nullable String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public @Nullable String getType() {
        return this.type;
    }

    @Override
    public @Nullable String getClassifier() {
        return this.classifier;
    }

    @Override
    public @NonNull @Nullable String getVersion() {
        return this.version;
    }

    @Override
    public @Nullable List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    @Override
    public @Nullable List<String> getJvmConfigArgs() {
        return this.jvmConfigArgs;
    }

    @Override
    public @Nullable String getMainClass() {
        return this.mainClass;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMavenProtocPlugin && this.equalsByValue((ImmutableMavenProtocPlugin)another);
    }

    private boolean equalsByValue(ImmutableMavenProtocPlugin another) {
        return Objects.equals(this.options, another.options) && Objects.equals(this.outputDirectory, another.outputDirectory) && Objects.equals(this.registerAsCompilationRoot, another.registerAsCompilationRoot) && this.order == another.order && this.skip == another.skip && Objects.equals(this.groupId, another.groupId) && Objects.equals(this.artifactId, another.artifactId) && Objects.equals(this.type, another.type) && Objects.equals(this.classifier, another.classifier) && Objects.equals(this.version, another.version) && Objects.equals(this.jvmArgs, another.jvmArgs) && Objects.equals(this.jvmConfigArgs, another.jvmConfigArgs) && Objects.equals(this.mainClass, another.mainClass);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.options);
        h += (h << 5) + Objects.hashCode(this.outputDirectory);
        h += (h << 5) + Objects.hashCode(this.registerAsCompilationRoot);
        h += (h << 5) + this.order;
        h += (h << 5) + Boolean.hashCode(this.skip);
        h += (h << 5) + Objects.hashCode(this.groupId);
        h += (h << 5) + Objects.hashCode(this.artifactId);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.classifier);
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + Objects.hashCode(this.jvmArgs);
        h += (h << 5) + Objects.hashCode(this.jvmConfigArgs);
        h += (h << 5) + Objects.hashCode(this.mainClass);
        return h;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="MavenProtocPlugin", generator="Immutables")
    private final class InitShim {
        private byte orderBuildStage = 0;
        private int order;
        private byte skipBuildStage = 0;
        private boolean skip;

        private InitShim() {
        }

        int getOrder() {
            if (this.orderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.orderBuildStage == 0) {
                int computedValue;
                this.orderBuildStage = (byte)-1;
                this.order = computedValue = ImmutableMavenProtocPlugin.super.getOrder();
                this.orderBuildStage = 1;
            }
            return this.order;
        }

        void order(int order) {
            this.order = order;
            this.orderBuildStage = 1;
        }

        boolean isSkip() {
            if (this.skipBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.skipBuildStage == 0) {
                boolean computedValue;
                this.skipBuildStage = (byte)-1;
                this.skip = computedValue = ImmutableMavenProtocPlugin.super.isSkip();
                this.skipBuildStage = 1;
            }
            return this.skip;
        }

        void skip(boolean skip) {
            this.skip = skip;
            this.skipBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.orderBuildStage == -1) {
                attributes.add("order");
            }
            if (this.skipBuildStage == -1) {
                attributes.add("skip");
            }
            return "Cannot build MavenProtocPlugin, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="MavenProtocPlugin", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_GROUP_ID = 1L;
        private static final long INIT_BIT_ARTIFACT_ID = 2L;
        private static final long INIT_BIT_VERSION = 4L;
        private static final long OPT_BIT_ORDER = 1L;
        private static final long OPT_BIT_SKIP = 2L;
        private long initBits = 7L;
        private long optBits;
        private @Nullable String options;
        private @Nullable Path outputDirectory;
        private @Nullable Boolean registerAsCompilationRoot;
        private int order;
        private boolean skip;
        private @Nullable String groupId;
        private @Nullable String artifactId;
        private @Nullable String type;
        private @Nullable String classifier;
        private @NonNull @Nullable String version;
        private @Nullable List<String> jvmArgs = null;
        private @Nullable List<String> jvmConfigArgs = null;
        private @Nullable String mainClass;

        private Builder() {
        }

        public final Builder from(MavenProtocPluginBean instance) {
            String mainClassValue;
            List<String> jvmConfigArgsValue;
            List<String> jvmArgsValue;
            String versionValue;
            String classifierValue;
            String typeValue;
            String artifactIdValue;
            String groupIdValue;
            Boolean registerAsCompilationRootValue;
            Path outputDirectoryValue;
            Objects.requireNonNull(instance, "instance");
            @Nullable String optionsValue = instance.getOptions();
            if (optionsValue != null) {
                this.options(optionsValue);
            }
            if ((outputDirectoryValue = instance.getOutputDirectory()) != null) {
                this.outputDirectory(outputDirectoryValue);
            }
            if ((registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot()) != null) {
                this.registerAsCompilationRoot(registerAsCompilationRootValue);
            }
            this.order(instance.getOrder());
            this.skip(instance.isSkip());
            if (instance.groupIdIsSet() && (groupIdValue = instance.getGroupId()) != null) {
                this.groupId(groupIdValue);
            }
            if (instance.artifactIdIsSet() && (artifactIdValue = instance.getArtifactId()) != null) {
                this.artifactId(artifactIdValue);
            }
            if ((typeValue = instance.getType()) != null) {
                this.type(typeValue);
            }
            if ((classifierValue = instance.getClassifier()) != null) {
                this.classifier(classifierValue);
            }
            if (instance.versionIsSet() && (versionValue = instance.getVersion()) != null) {
                this.version(versionValue);
            }
            if ((jvmArgsValue = instance.getJvmArgs()) != null) {
                this.addAllJvmArgs(jvmArgsValue);
            }
            if ((jvmConfigArgsValue = instance.getJvmConfigArgs()) != null) {
                this.addAllJvmConfigArgs(jvmConfigArgsValue);
            }
            if ((mainClassValue = instance.getMainClass()) != null) {
                this.mainClass(mainClassValue);
            }
            return this;
        }

        public final Builder from(MavenArtifact instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(MavenProtocPlugin instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(ProtocPlugin instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Object instance;
            if (object instanceof MavenProtocPluginBean) {
                this.from((MavenProtocPluginBean)object);
                return;
            }
            long bits = 0L;
            if (object instanceof MavenArtifact) {
                instance = (MavenArtifact)object;
                if ((bits & 0x40L) == 0L) {
                    @Nullable String classifierValue = ((MavenArtifact)instance).getClassifier();
                    if (classifierValue != null) {
                        this.classifier(classifierValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x100L) == 0L) {
                    String artifactIdValue = ((MavenArtifact)instance).getArtifactId();
                    if (artifactIdValue != null) {
                        this.artifactId(artifactIdValue);
                    }
                    bits |= 0x100L;
                }
                if ((bits & 8L) == 0L) {
                    @Nullable String typeValue = ((MavenArtifact)instance).getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    @NonNull String versionValue = ((MavenArtifact)instance).getVersion();
                    if (versionValue != null) {
                        this.version(versionValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 2L) == 0L) {
                    String groupIdValue = ((MavenArtifact)instance).getGroupId();
                    if (groupIdValue != null) {
                        this.groupId(groupIdValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof MavenProtocPlugin) {
                List<String> jvmConfigArgsValue;
                List<String> jvmArgsValue;
                instance = (MavenProtocPlugin)object;
                @Nullable String mainClassValue = ((MavenProtocPlugin)instance).getMainClass();
                if (mainClassValue != null) {
                    this.mainClass(mainClassValue);
                }
                if ((bits & 1L) == 0L) {
                    @Nullable Boolean registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot();
                    if (registerAsCompilationRootValue != null) {
                        this.registerAsCompilationRoot(registerAsCompilationRootValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    String groupIdValue = ((MavenArtifact)instance).getGroupId();
                    if (groupIdValue != null) {
                        this.groupId(groupIdValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.skip(instance.isSkip());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    @Nullable String typeValue = ((MavenArtifact)instance).getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    @NonNull String versionValue = ((MavenProtocPlugin)instance).getVersion();
                    if (versionValue != null) {
                        this.version(versionValue);
                    }
                    bits |= 0x10L;
                }
                if ((jvmArgsValue = ((MavenProtocPlugin)instance).getJvmArgs()) != null) {
                    this.addAllJvmArgs(jvmArgsValue);
                }
                if ((bits & 0x20L) == 0L) {
                    @Nullable String optionsValue = instance.getOptions();
                    if (optionsValue != null) {
                        this.options(optionsValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    @Nullable String classifierValue = ((MavenArtifact)instance).getClassifier();
                    if (classifierValue != null) {
                        this.classifier(classifierValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    @Nullable Path outputDirectoryValue = instance.getOutputDirectory();
                    if (outputDirectoryValue != null) {
                        this.outputDirectory(outputDirectoryValue);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    String artifactIdValue = ((MavenArtifact)instance).getArtifactId();
                    if (artifactIdValue != null) {
                        this.artifactId(artifactIdValue);
                    }
                    bits |= 0x100L;
                }
                if ((jvmConfigArgsValue = ((MavenProtocPlugin)instance).getJvmConfigArgs()) != null) {
                    this.addAllJvmConfigArgs(jvmConfigArgsValue);
                }
                if ((bits & 0x200L) == 0L) {
                    this.order(instance.getOrder());
                    bits |= 0x200L;
                }
            }
            if (object instanceof ProtocPlugin) {
                instance = (ProtocPlugin)object;
                if ((bits & 0x20L) == 0L) {
                    @Nullable String optionsValue = instance.getOptions();
                    if (optionsValue != null) {
                        this.options(optionsValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 4L) == 0L) {
                    this.skip(instance.isSkip());
                    bits |= 4L;
                }
                if ((bits & 0x80L) == 0L) {
                    @Nullable Path outputDirectoryValue = instance.getOutputDirectory();
                    if (outputDirectoryValue != null) {
                        this.outputDirectory(outputDirectoryValue);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 1L) == 0L) {
                    @Nullable Boolean registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot();
                    if (registerAsCompilationRootValue != null) {
                        this.registerAsCompilationRoot(registerAsCompilationRootValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.order(instance.getOrder());
                    bits |= 0x200L;
                }
            }
        }

        public final Builder options(@Nullable String options) {
            this.options = options;
            return this;
        }

        public final Builder outputDirectory(@Nullable Path outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        public final Builder registerAsCompilationRoot(@Nullable Boolean registerAsCompilationRoot) {
            this.registerAsCompilationRoot = registerAsCompilationRoot;
            return this;
        }

        public final Builder order(int order) {
            this.order = order;
            this.optBits |= 1L;
            return this;
        }

        public final Builder skip(boolean skip) {
            this.skip = skip;
            this.optBits |= 2L;
            return this;
        }

        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        public final Builder classifier(@Nullable String classifier) {
            this.classifier = classifier;
            return this;
        }

        public final Builder version(@NonNull String version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addJvmArgs(@Nullable String element) {
            if (this.jvmArgs == null) {
                this.jvmArgs = new ArrayList<String>();
            }
            this.jvmArgs.add(element);
            return this;
        }

        public final Builder addJvmArgs(String ... elements) {
            if (this.jvmArgs == null) {
                this.jvmArgs = new ArrayList<String>();
            }
            for (String element : elements) {
                this.jvmArgs.add(element);
            }
            return this;
        }

        public final Builder jvmArgs(@Nullable Iterable<@Nullable String> elements) {
            if (elements == null) {
                this.jvmArgs = null;
                return this;
            }
            this.jvmArgs = new ArrayList<String>();
            return this.addAllJvmArgs(elements);
        }

        public final Builder addAllJvmArgs(Iterable<@Nullable String> elements) {
            Objects.requireNonNull(elements, "jvmArgs element");
            if (this.jvmArgs == null) {
                this.jvmArgs = new ArrayList<String>();
            }
            for (String element : elements) {
                this.jvmArgs.add(element);
            }
            return this;
        }

        public final Builder addJvmConfigArgs(@Nullable String element) {
            if (this.jvmConfigArgs == null) {
                this.jvmConfigArgs = new ArrayList<String>();
            }
            this.jvmConfigArgs.add(element);
            return this;
        }

        public final Builder addJvmConfigArgs(String ... elements) {
            if (this.jvmConfigArgs == null) {
                this.jvmConfigArgs = new ArrayList<String>();
            }
            for (String element : elements) {
                this.jvmConfigArgs.add(element);
            }
            return this;
        }

        public final Builder jvmConfigArgs(@Nullable Iterable<@Nullable String> elements) {
            if (elements == null) {
                this.jvmConfigArgs = null;
                return this;
            }
            this.jvmConfigArgs = new ArrayList<String>();
            return this.addAllJvmConfigArgs(elements);
        }

        public final Builder addAllJvmConfigArgs(Iterable<@Nullable String> elements) {
            Objects.requireNonNull(elements, "jvmConfigArgs element");
            if (this.jvmConfigArgs == null) {
                this.jvmConfigArgs = new ArrayList<String>();
            }
            for (String element : elements) {
                this.jvmConfigArgs.add(element);
            }
            return this;
        }

        public final Builder mainClass(@Nullable String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public ImmutableMavenProtocPlugin build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMavenProtocPlugin(this);
        }

        private boolean orderIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean skipIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("groupId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("artifactId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build MavenProtocPlugin, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

