/*
 * Decompiled with CFR 0.152.
 */
package io.github.asleepyfish.config;

import io.github.asleepyfish.enums.model.ModelEnum;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="chatgpt")
public class ChatGPTProperties {
    private String token;
    private String model;
    private String chatModel;
    private int retries;
    private String proxyHost;
    private int proxyPort;
    private Integer sessionExpirationTime;

    private static String $default$model() {
        return ModelEnum.TEXT_DAVINCI_003.getModelName();
    }

    private static String $default$chatModel() {
        return ModelEnum.GPT_35_TURBO.getModelName();
    }

    private static int $default$retries() {
        return 5;
    }

    public static ChatGPTPropertiesBuilder builder() {
        return new ChatGPTPropertiesBuilder();
    }

    public String getToken() {
        return this.token;
    }

    public String getModel() {
        return this.model;
    }

    public String getChatModel() {
        return this.chatModel;
    }

    public int getRetries() {
        return this.retries;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public Integer getSessionExpirationTime() {
        return this.sessionExpirationTime;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setChatModel(String chatModel) {
        this.chatModel = chatModel;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setSessionExpirationTime(Integer sessionExpirationTime) {
        this.sessionExpirationTime = sessionExpirationTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatGPTProperties)) {
            return false;
        }
        ChatGPTProperties other = (ChatGPTProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRetries() != other.getRetries()) {
            return false;
        }
        if (this.getProxyPort() != other.getProxyPort()) {
            return false;
        }
        Integer this$sessionExpirationTime = this.getSessionExpirationTime();
        Integer other$sessionExpirationTime = other.getSessionExpirationTime();
        if (this$sessionExpirationTime == null ? other$sessionExpirationTime != null : !((Object)this$sessionExpirationTime).equals(other$sessionExpirationTime)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$chatModel = this.getChatModel();
        String other$chatModel = other.getChatModel();
        if (this$chatModel == null ? other$chatModel != null : !this$chatModel.equals(other$chatModel)) {
            return false;
        }
        String this$proxyHost = this.getProxyHost();
        String other$proxyHost = other.getProxyHost();
        return !(this$proxyHost == null ? other$proxyHost != null : !this$proxyHost.equals(other$proxyHost));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatGPTProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRetries();
        result = result * 59 + this.getProxyPort();
        Integer $sessionExpirationTime = this.getSessionExpirationTime();
        result = result * 59 + ($sessionExpirationTime == null ? 43 : ((Object)$sessionExpirationTime).hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $chatModel = this.getChatModel();
        result = result * 59 + ($chatModel == null ? 43 : $chatModel.hashCode());
        String $proxyHost = this.getProxyHost();
        result = result * 59 + ($proxyHost == null ? 43 : $proxyHost.hashCode());
        return result;
    }

    public String toString() {
        return "ChatGPTProperties(token=" + this.getToken() + ", model=" + this.getModel() + ", chatModel=" + this.getChatModel() + ", retries=" + this.getRetries() + ", proxyHost=" + this.getProxyHost() + ", proxyPort=" + this.getProxyPort() + ", sessionExpirationTime=" + this.getSessionExpirationTime() + ")";
    }

    public ChatGPTProperties() {
        this.model = ChatGPTProperties.$default$model();
        this.chatModel = ChatGPTProperties.$default$chatModel();
        this.retries = ChatGPTProperties.$default$retries();
    }

    public ChatGPTProperties(String token, String model, String chatModel, int retries, String proxyHost, int proxyPort, Integer sessionExpirationTime) {
        this.token = token;
        this.model = model;
        this.chatModel = chatModel;
        this.retries = retries;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.sessionExpirationTime = sessionExpirationTime;
    }

    public static class ChatGPTPropertiesBuilder {
        private String token;
        private boolean model$set;
        private String model$value;
        private boolean chatModel$set;
        private String chatModel$value;
        private boolean retries$set;
        private int retries$value;
        private String proxyHost;
        private int proxyPort;
        private Integer sessionExpirationTime;

        ChatGPTPropertiesBuilder() {
        }

        public ChatGPTPropertiesBuilder token(String token) {
            this.token = token;
            return this;
        }

        public ChatGPTPropertiesBuilder model(String model) {
            this.model$value = model;
            this.model$set = true;
            return this;
        }

        public ChatGPTPropertiesBuilder chatModel(String chatModel) {
            this.chatModel$value = chatModel;
            this.chatModel$set = true;
            return this;
        }

        public ChatGPTPropertiesBuilder retries(int retries) {
            this.retries$value = retries;
            this.retries$set = true;
            return this;
        }

        public ChatGPTPropertiesBuilder proxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public ChatGPTPropertiesBuilder proxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public ChatGPTPropertiesBuilder sessionExpirationTime(Integer sessionExpirationTime) {
            this.sessionExpirationTime = sessionExpirationTime;
            return this;
        }

        public ChatGPTProperties build() {
            String model$value = this.model$value;
            if (!this.model$set) {
                model$value = ChatGPTProperties.$default$model();
            }
            String chatModel$value = this.chatModel$value;
            if (!this.chatModel$set) {
                chatModel$value = ChatGPTProperties.$default$chatModel();
            }
            int retries$value = this.retries$value;
            if (!this.retries$set) {
                retries$value = ChatGPTProperties.$default$retries();
            }
            return new ChatGPTProperties(this.token, model$value, chatModel$value, retries$value, this.proxyHost, this.proxyPort, this.sessionExpirationTime);
        }

        public String toString() {
            return "ChatGPTProperties.ChatGPTPropertiesBuilder(token=" + this.token + ", model$value=" + this.model$value + ", chatModel$value=" + this.chatModel$value + ", retries$value=" + this.retries$value + ", proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", sessionExpirationTime=" + this.sessionExpirationTime + ")";
        }
    }
}

