/*
 * Decompiled with CFR 0.152.
 */
package io.github.asleepyfish.entity.audio;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import lombok.NonNull;

public class TranscriptionRequest {
    private File file;
    @NonNull
    private String model;
    private String prompt;
    @JsonProperty(value="response_format")
    private String responseFormat;
    private Double temperature;
    private String language;

    TranscriptionRequest(File file, @NonNull String model, String prompt, String responseFormat, Double temperature, String language) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.file = file;
        this.model = model;
        this.prompt = prompt;
        this.responseFormat = responseFormat;
        this.temperature = temperature;
        this.language = language;
    }

    public static TranscriptionRequestBuilder builder() {
        return new TranscriptionRequestBuilder();
    }

    public File getFile() {
        return this.file;
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setModel(@NonNull String model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    @JsonProperty(value="response_format")
    public void setResponseFormat(String responseFormat) {
        this.responseFormat = responseFormat;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranscriptionRequest)) {
            return false;
        }
        TranscriptionRequest other = (TranscriptionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$prompt = this.getPrompt();
        String other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt)) {
            return false;
        }
        String this$responseFormat = this.getResponseFormat();
        String other$responseFormat = other.getResponseFormat();
        if (this$responseFormat == null ? other$responseFormat != null : !this$responseFormat.equals(other$responseFormat)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        return !(this$language == null ? other$language != null : !this$language.equals(other$language));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TranscriptionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        String $responseFormat = this.getResponseFormat();
        result = result * 59 + ($responseFormat == null ? 43 : $responseFormat.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        return result;
    }

    public String toString() {
        return "TranscriptionRequest(file=" + this.getFile() + ", model=" + this.getModel() + ", prompt=" + this.getPrompt() + ", responseFormat=" + this.getResponseFormat() + ", temperature=" + this.getTemperature() + ", language=" + this.getLanguage() + ")";
    }

    public static class TranscriptionRequestBuilder {
        private File file;
        private String model;
        private String prompt;
        private String responseFormat;
        private Double temperature;
        private String language;

        TranscriptionRequestBuilder() {
        }

        public TranscriptionRequestBuilder file(File file) {
            this.file = file;
            return this;
        }

        public TranscriptionRequestBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public TranscriptionRequestBuilder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        @JsonProperty(value="response_format")
        public TranscriptionRequestBuilder responseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public TranscriptionRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public TranscriptionRequestBuilder language(String language) {
            this.language = language;
            return this;
        }

        public TranscriptionRequest build() {
            return new TranscriptionRequest(this.file, this.model, this.prompt, this.responseFormat, this.temperature, this.language);
        }

        public String toString() {
            return "TranscriptionRequest.TranscriptionRequestBuilder(file=" + this.file + ", model=" + this.model + ", prompt=" + this.prompt + ", responseFormat=" + this.responseFormat + ", temperature=" + this.temperature + ", language=" + this.language + ")";
        }
    }
}

