/*
 * Decompiled with CFR 0.152.
 */
package io.github.asleepyfish.enums.model;

import io.github.asleepyfish.enums.exception.ChatGPTErrorEnum;
import io.github.asleepyfish.exception.ChatGPTException;
import java.util.Objects;

public enum ModelEnum {
    GPT_4("gpt-4", 8192),
    GPT_4_0314("gpt-4-0314", 8192),
    GPT_4_32K("gpt-4-32k", 32768),
    GPT_4_32K_0314("gpt-4-32k-0314", 32768),
    GPT_35_TURBO_16K("gpt-3.5-turbo-16k", 16384),
    GPT_35_TURBO_0613("gpt-3.5-turbo-0613", 4096),
    GPT_35_TURBO_16K_0613("gpt-3.5-turbo-16k-0613", 16384),
    GPT_35_TURBO("gpt-3.5-turbo", 4096),
    GPT_35_TURBO_0301("gpt-3.5-turbo-0301", 4096),
    TEXT_DAVINCI_003("text-davinci-003", 4000),
    TEXT_CURIE_001("text-curie-001", 2048),
    TEXT_BABBAGE_001("text-babbage-001", 2048),
    TEXT_ADA_001("text-ada-001", 2048);

    private final String modelName;
    private final Integer maxTokens;

    public static Integer getMaxTokens(String modelName) {
        for (ModelEnum modelEnum : ModelEnum.values()) {
            if (!Objects.equals(modelEnum.getModelName(), modelName)) continue;
            return modelEnum.getMaxTokens();
        }
        throw new ChatGPTException(ChatGPTErrorEnum.MODEL_SELECTION_ERROR);
    }

    public String getModelName() {
        return this.modelName;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    private ModelEnum(String modelName, Integer maxTokens) {
        this.modelName = modelName;
        this.maxTokens = maxTokens;
    }
}

