/*
 * Decompiled with CFR 0.152.
 */
package io.github.asleepyfish.service;

import com.alibaba.fastjson2.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.theokanning.openai.DeleteResult;
import com.theokanning.openai.client.OpenAiApi;
import com.theokanning.openai.completion.CompletionRequest;
import com.theokanning.openai.completion.CompletionResult;
import com.theokanning.openai.completion.chat.ChatCompletionChoice;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.edit.EditRequest;
import com.theokanning.openai.edit.EditResult;
import com.theokanning.openai.embedding.Embedding;
import com.theokanning.openai.embedding.EmbeddingRequest;
import com.theokanning.openai.embedding.EmbeddingResult;
import com.theokanning.openai.file.File;
import com.theokanning.openai.finetune.FineTuneEvent;
import com.theokanning.openai.finetune.FineTuneRequest;
import com.theokanning.openai.finetune.FineTuneResult;
import com.theokanning.openai.image.CreateImageEditRequest;
import com.theokanning.openai.image.CreateImageRequest;
import com.theokanning.openai.image.CreateImageVariationRequest;
import com.theokanning.openai.image.ImageResult;
import com.theokanning.openai.moderation.ModerationRequest;
import com.theokanning.openai.moderation.ModerationResult;
import com.theokanning.openai.service.OpenAiService;
import io.github.asleepyfish.config.ChatGPTProperties;
import io.github.asleepyfish.entity.audio.TranscriptionRequest;
import io.github.asleepyfish.entity.audio.TranslationRequest;
import io.github.asleepyfish.entity.billing.Billing;
import io.github.asleepyfish.entity.billing.Subscription;
import io.github.asleepyfish.enums.audio.AudioModelEnum;
import io.github.asleepyfish.enums.audio.AudioResponseFormatEnum;
import io.github.asleepyfish.enums.chat.FinishReasonEnum;
import io.github.asleepyfish.enums.chat.RoleEnum;
import io.github.asleepyfish.enums.edit.EditModelEnum;
import io.github.asleepyfish.enums.embedding.EmbeddingModelEnum;
import io.github.asleepyfish.enums.exception.ChatGPTErrorEnum;
import io.github.asleepyfish.enums.image.ImageResponseFormatEnum;
import io.github.asleepyfish.enums.image.ImageSizeEnum;
import io.github.asleepyfish.enums.model.ModelEnum;
import io.github.asleepyfish.exception.ChatGPTException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import retrofit2.Retrofit;

public class OpenAiProxyService
extends OpenAiService {
    private static final Log LOG = LogFactory.getLog(OpenAiProxyService.class);
    private static final String BASE_URL = "https://api.openai.com";
    private static final Random RANDOM = new Random();
    private final ChatGPTProperties chatGPTProperties;
    private final OkHttpClient client;
    private Cache<String, LinkedList<ChatMessage>> cache;

    public OpenAiProxyService(ChatGPTProperties chatGPTProperties, Duration timeout) {
        super(OpenAiProxyService.buildApi(chatGPTProperties.getToken(), timeout, chatGPTProperties.getProxyHost(), chatGPTProperties.getProxyPort()), OpenAiProxyService.defaultClient(chatGPTProperties.getToken(), timeout, chatGPTProperties.getProxyHost(), chatGPTProperties.getProxyPort()).dispatcher().executorService());
        this.chatGPTProperties = chatGPTProperties;
        this.cache = chatGPTProperties.getSessionExpirationTime() == null ? CacheBuilder.newBuilder().build() : CacheBuilder.newBuilder().expireAfterAccess((long)chatGPTProperties.getSessionExpirationTime().intValue(), TimeUnit.MINUTES).build();
        this.client = OpenAiProxyService.defaultClient(chatGPTProperties.getToken(), timeout, chatGPTProperties.getProxyHost(), chatGPTProperties.getProxyPort());
    }

    public OpenAiProxyService(ChatGPTProperties chatGPTProperties) {
        this(chatGPTProperties, Duration.ZERO);
    }

    public static OpenAiApi buildApi(String token, Duration timeout, String proxyHost, int proxyPort) {
        ObjectMapper mapper = OpenAiProxyService.defaultObjectMapper();
        OkHttpClient client = OpenAiProxyService.defaultClient(token, timeout, proxyHost, proxyPort);
        Retrofit retrofit = OpenAiProxyService.defaultRetrofit((OkHttpClient)client, (ObjectMapper)mapper);
        return (OpenAiApi)retrofit.create(OpenAiApi.class);
    }

    public static OkHttpClient defaultClient(String token, Duration timeout, String proxyHost, int proxyPort) {
        if (Strings.isNullOrEmpty((String)proxyHost)) {
            return OpenAiService.defaultClient((String)token, (Duration)timeout);
        }
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
        return OpenAiService.defaultClient((String)token, (Duration)timeout).newBuilder().proxy(proxy).build();
    }

    public void createStreamChatCompletion(String content) {
        this.createStreamChatCompletion(content, "DEFAULT USER", System.out);
    }

    public void createStreamChatCompletion(String content, OutputStream os) {
        this.createStreamChatCompletion(content, "DEFAULT USER", os);
    }

    public void createStreamChatCompletion(String content, String user, OutputStream os) {
        this.createStreamChatCompletion(content, user, this.chatGPTProperties.getChatModel(), os);
    }

    public void createStreamChatCompletion(String content, String user, String model, OutputStream os) {
        this.createStreamChatCompletion(RoleEnum.USER.getRoleName(), content, user, model, 1.0, 1.0, os);
    }

    public void createStreamChatCompletion(String role, String content, String user, String model, Double temperature, Double topP, OutputStream os) {
        this.createStreamChatCompletion(ChatCompletionRequest.builder().model(model).messages(Collections.singletonList(new ChatMessage(role, content))).user(user).temperature(temperature).topP(topP).stream(Boolean.valueOf(true)).build(), os);
    }

    public void createStreamChatCompletion(ChatCompletionRequest chatCompletionRequest, OutputStream os) {
        chatCompletionRequest.setStream(Boolean.valueOf(true));
        chatCompletionRequest.setN(Integer.valueOf(1));
        String user = chatCompletionRequest.getUser();
        LinkedList contextInfo = new LinkedList();
        try {
            contextInfo = (LinkedList)this.cache.get((Object)user, LinkedList::new);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        contextInfo.addAll(chatCompletionRequest.getMessages());
        chatCompletionRequest.setMessages((List)contextInfo);
        ArrayList chunks = new ArrayList();
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    this.randomSleep();
                }
                super.streamChatCompletion(chatCompletionRequest).doOnError(Throwable::printStackTrace).blockingForEach(chunk -> {
                    chunk.getChoices().stream().map(choice -> choice.getMessage().getContent()).filter(Objects::nonNull).findFirst().ifPresent(o -> {
                        try {
                            os.write(o.getBytes(Charset.defaultCharset()));
                            os.flush();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                    chunks.add(chunk);
                });
                os.close();
                break;
            }
            catch (Exception e) {
                String message = e.getMessage();
                boolean overload = OpenAiProxyService.checkTokenUsage(message);
                if (overload) {
                    int size = ((LinkedList)Objects.requireNonNull(this.cache.getIfPresent((Object)user))).size();
                    for (int j = 0; j < size / 2; ++j) {
                        ((LinkedList)Objects.requireNonNull(this.cache.getIfPresent((Object)user))).removeFirst();
                    }
                    chatCompletionRequest.setMessages((List)this.cache.getIfPresent((Object)user));
                }
                LOG.error((Object)("answer failed " + (i + 1) + " times, the error message is: " + message));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                ((LinkedList)Objects.requireNonNull(this.cache.getIfPresent((Object)user))).removeLast();
                throw new ChatGPTException(ChatGPTErrorEnum.FAILED_TO_GENERATE_ANSWER, message);
            }
        }
        LinkedList chatMessages = new LinkedList();
        try {
            chatMessages = (LinkedList)this.cache.get((Object)user, LinkedList::new);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        chatMessages.add(new ChatMessage(RoleEnum.ASSISTANT.getRoleName(), chunks.stream().flatMap(chunk -> chunk.getChoices().stream()).map(ChatCompletionChoice::getMessage).map(ChatMessage::getContent).filter(Objects::nonNull).collect(Collectors.joining())));
    }

    public List<String> chatCompletion(String content) {
        return this.chatCompletion(content, "DEFAULT USER");
    }

    public List<String> chatCompletion(String content, String user) {
        return this.chatCompletion(content, user, this.chatGPTProperties.getChatModel());
    }

    public List<String> chatCompletion(String content, String user, String model) {
        return this.chatCompletion(RoleEnum.USER.getRoleName(), content, user, model, 1.0, 1.0);
    }

    public List<String> chatCompletion(String role, String content, String user, String model, Double temperature, Double topP) {
        return this.chatCompletion(ChatCompletionRequest.builder().model(model).messages(Collections.singletonList(new ChatMessage(role, content))).user(user).temperature(temperature).topP(topP).build());
    }

    public List<String> chatCompletion(ChatCompletionRequest chatCompletionRequest) {
        String user = chatCompletionRequest.getUser();
        LinkedList contextInfo = new LinkedList();
        try {
            contextInfo = (LinkedList)this.cache.get((Object)user, LinkedList::new);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        contextInfo.addAll(chatCompletionRequest.getMessages());
        chatCompletionRequest.setMessages((List)contextInfo);
        List choices = new ArrayList();
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    this.randomSleep();
                }
                choices = super.createChatCompletion(chatCompletionRequest).getChoices();
                break;
            }
            catch (Exception e) {
                String message = e.getMessage();
                boolean overload = OpenAiProxyService.checkTokenUsage(message);
                if (overload) {
                    int size = ((LinkedList)Objects.requireNonNull(this.cache.getIfPresent((Object)user))).size();
                    for (int j = 0; j < size / 2; ++j) {
                        ((LinkedList)Objects.requireNonNull(this.cache.getIfPresent((Object)user))).removeFirst();
                    }
                    chatCompletionRequest.setMessages((List)this.cache.getIfPresent((Object)user));
                }
                LOG.error((Object)("answer failed " + (i + 1) + " times, the error message is: " + message));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                ((LinkedList)Objects.requireNonNull(this.cache.getIfPresent((Object)user))).removeLast();
                throw new ChatGPTException(ChatGPTErrorEnum.FAILED_TO_GENERATE_ANSWER, message);
            }
        }
        ArrayList<String> results = new ArrayList<String>();
        LinkedList chatMessages = new LinkedList();
        try {
            chatMessages = (LinkedList)this.cache.get((Object)user, LinkedList::new);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        for (ChatCompletionChoice choice : choices) {
            String text = choice.getMessage().getContent();
            results.add(text);
            if (FinishReasonEnum.LENGTH.getMessage().equals(choice.getFinishReason())) {
                results.add("\u7b54\u6848\u8fc7\u957f\uff0c\u8bf7\u8f93\u5165\u7ee7\u7eed~");
            }
            chatMessages.add(choice.getMessage());
        }
        return results;
    }

    @Deprecated
    public List<String> completion(String prompt) {
        return this.completion(prompt, "DEFAULT USER");
    }

    @Deprecated
    public List<String> completion(String prompt, String user) {
        return this.completion(prompt, user, this.chatGPTProperties.getModel());
    }

    @Deprecated
    public List<String> completion(String prompt, String user, String model) {
        return this.completion(prompt, user, model, 0.0, 1.0);
    }

    @Deprecated
    public List<String> completion(String prompt, String user, String model, Double temperature, Double topP) {
        return this.completion(CompletionRequest.builder().model(model).prompt(prompt).user(user).temperature(temperature).topP(topP).maxTokens(ModelEnum.getMaxTokens(model)).build());
    }

    @Deprecated
    public List<String> completion(CompletionRequest completionRequest) {
        List choices = new ArrayList();
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    this.randomSleep();
                }
                choices = super.createCompletion(completionRequest).getChoices();
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("answer failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.FAILED_TO_GENERATE_ANSWER, e.getMessage());
            }
        }
        ArrayList<String> results = new ArrayList<String>();
        choices.forEach(choice -> {
            String text = choice.getText();
            if (FinishReasonEnum.LENGTH.getMessage().equals(choice.getFinish_reason())) {
                text = text + System.lineSeparator() + "The answer is too long, Please disassemble the above problems into several minor problems.";
            }
            results.add(text);
        });
        return results;
    }

    public List<String> createImages(String prompt) {
        return this.createImages(prompt, "DEFAULT USER");
    }

    public List<String> createImages(String prompt, String user) {
        return this.createImages(prompt, user, ImageResponseFormatEnum.URL);
    }

    public List<String> createImages(String prompt, String user, ImageResponseFormatEnum responseFormat) {
        ImageResult imageResult = this.createImages(CreateImageRequest.builder().prompt(prompt).user(user).responseFormat(responseFormat.getResponseFormat()).build());
        String format = responseFormat.getResponseFormat();
        return imageResult.getData().stream().map(image -> format == null || ImageResponseFormatEnum.URL.getResponseFormat().equals(format) ? image.getUrl() : image.getB64Json()).collect(Collectors.toList());
    }

    public ImageResult createImages(CreateImageRequest createImageRequest) {
        ImageResult imageResult = new ImageResult();
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    this.randomSleep();
                }
                imageResult = super.createImage(createImageRequest);
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("image generate failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.FAILED_TO_GENERATE_IMAGE, e.getMessage());
            }
        }
        return imageResult;
    }

    public void downloadImage(String prompt, HttpServletResponse response) {
        this.downloadImage(prompt, ImageSizeEnum.S1024x1024.getSize(), response);
    }

    public void downloadImage(String prompt, Integer n, HttpServletResponse response) {
        this.downloadImage(prompt, n, ImageSizeEnum.S1024x1024.getSize(), response);
    }

    public void downloadImage(String prompt, String size, HttpServletResponse response) {
        this.downloadImage(prompt, 1, size, response);
    }

    public void downloadImage(String prompt, Integer n, String size, HttpServletResponse response) {
        this.downloadImage(CreateImageRequest.builder().prompt(prompt).n(n).size(size).user("DEFAULT USER").build(), response);
    }

    public void downloadImage(CreateImageRequest createImageRequest, HttpServletResponse response) {
        block29: {
            createImageRequest.setResponseFormat(ImageResponseFormatEnum.B64_JSON.getResponseFormat());
            if (!ImageResponseFormatEnum.B64_JSON.getResponseFormat().equals(createImageRequest.getResponseFormat())) {
                throw new ChatGPTException(ChatGPTErrorEnum.ERROR_RESPONSE_FORMAT);
            }
            List imageList = this.createImages(createImageRequest).getData().stream().map(com.theokanning.openai.image.Image::getB64Json).collect(Collectors.toList());
            try (ServletOutputStream os = response.getOutputStream();){
                if (imageList.size() == 1) {
                    response.setContentType("image/png");
                    response.setHeader("Content-Disposition", "attachment; filename=generated.png");
                    BufferedImage bufferedImage = this.getImageFromBase64((String)imageList.get(0));
                    ImageIO.write((RenderedImage)bufferedImage, "png", (OutputStream)os);
                    break block29;
                }
                response.setContentType("application/zip");
                response.setHeader("Content-Disposition", "attachment; filename=images.zip");
                try (ZipOutputStream zipOut = new ZipOutputStream((OutputStream)os);){
                    for (int i = 0; i < imageList.size(); ++i) {
                        BufferedImage bufferedImage = this.getImageFromBase64((String)imageList.get(i));
                        ZipEntry zipEntry = new ZipEntry("image" + (i + 1) + ".png");
                        zipOut.putNextEntry(zipEntry);
                        ImageIO.write((RenderedImage)bufferedImage, "png", zipOut);
                        zipOut.closeEntry();
                    }
                }
            }
            catch (Exception e) {
                throw new ChatGPTException(ChatGPTErrorEnum.DOWNLOAD_IMAGE_ERROR);
            }
        }
    }

    public String billingUsage(String ... startDate) {
        String start = startDate.length == 0 ? "2023-01-01" : startDate[0];
        BigDecimal totalUsage = BigDecimal.ZERO;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        try {
            LocalDate endDate = LocalDate.now();
            Period threeMonth = Period.ofMonths(3);
            LocalDate nextDate = LocalDate.parse(start, formatter);
            while (nextDate.isBefore(endDate)) {
                String left = nextDate.format(formatter);
                nextDate = nextDate.plus(threeMonth);
                String right = nextDate.format(formatter);
                totalUsage = totalUsage.add(new BigDecimal(this.billingUsage(left, right)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return totalUsage.toPlainString();
    }

    public String billingUsage(String startDate, String endDate) {
        HttpUrl.Builder urlBuildr = HttpUrl.parse((String)"https://api.openai.com/v1/dashboard/billing/usage").newBuilder();
        urlBuildr.addQueryParameter("start_date", startDate);
        urlBuildr.addQueryParameter("end_date", endDate);
        String url = urlBuildr.build().toString();
        Request request = new Request.Builder().url(url).build();
        String billingUsage = "0";
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try (Response response = this.client.newCall(request).execute();){
                if (i > 0) {
                    this.randomSleep();
                }
                String resStr = response.body().string();
                JSONObject resJson = JSONObject.parseObject((String)resStr);
                String cents = resJson.get("total_usage").toString();
                billingUsage = new BigDecimal(cents).divide(new BigDecimal("100")).toPlainString();
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("query billingUsage failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.QUERY_BILLINGUSAGE_ERROR, e.getMessage());
            }
        }
        return billingUsage;
    }

    public Billing billing(String ... startDate) {
        String start = startDate.length == 0 ? "2023-01-01" : startDate[0];
        Subscription subscription = this.subscription();
        String usage = this.billingUsage(start);
        String dueDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date(subscription.getAccessUntil() * 1000L));
        String total = subscription.getSystemHardLimitUsd();
        Billing billing = new Billing();
        billing.setDueDate(dueDate);
        billing.setTotal(total);
        billing.setUsage(usage);
        billing.setBalance(new BigDecimal(total).subtract(new BigDecimal(usage)).toPlainString());
        return billing;
    }

    public Subscription subscription() {
        Request request = new Request.Builder().url("https://api.openai.com/v1/dashboard/billing/subscription").build();
        Subscription subscription = null;
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try (Response response = this.client.newCall(request).execute();){
                if (i > 0) {
                    this.randomSleep();
                }
                String resStr = response.body().string();
                subscription = (Subscription)JSONObject.parseObject((String)resStr, Subscription.class);
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("query billingUsage failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.QUERY_BILLINGUSAGE_ERROR, e.getMessage());
            }
        }
        return subscription;
    }

    public String edit(String input, String instruction) {
        return this.edit(input, instruction, EditModelEnum.TEXT_DAVINCI_EDIT_001);
    }

    public String edit(String input, String instruction, EditModelEnum editModelEnum) {
        return this.edit(input, instruction, 1.0, 1.0, editModelEnum);
    }

    public String edit(String input, String instruction, Double temperature, Double topP, EditModelEnum editModelEnum) {
        EditResult editResult = this.edit(EditRequest.builder().model(editModelEnum.getModelName()).input(input).instruction(instruction).temperature(temperature).topP(topP).build());
        ArrayList results = Lists.newArrayList();
        editResult.getChoices().forEach(choice -> results.add(choice.getText()));
        return (String)results.get(0);
    }

    public EditResult edit(EditRequest editRequest) {
        EditResult editResult = new EditResult();
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    this.randomSleep();
                }
                editResult = super.createEdit(editRequest);
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("edit failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.EDIT_ERROR, e.getMessage());
            }
        }
        return editResult;
    }

    public List<Double> embeddings(String input) {
        return this.embeddings(input, EmbeddingModelEnum.TEXT_EMBEDDING_ADA_002);
    }

    public List<Double> embeddings(String input, EmbeddingModelEnum embeddingModelEnum) {
        return ((Embedding)this.embeddings(EmbeddingRequest.builder().input(Collections.singletonList(input)).model(embeddingModelEnum.getModelName()).build()).getData().get(0)).getEmbedding();
    }

    public EmbeddingResult embeddings(EmbeddingRequest embeddingRequest) {
        EmbeddingResult embeddingResult = new EmbeddingResult();
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    this.randomSleep();
                }
                embeddingResult = super.createEmbeddings(embeddingRequest);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)("embeddings failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.EMBEDDINGS_ERROR, e.getMessage());
            }
        }
        return embeddingResult;
    }

    public String transcription(String filePath, AudioResponseFormatEnum audioResponseFormatEnum) {
        java.io.File file = new java.io.File(filePath);
        return this.transcription(file, audioResponseFormatEnum);
    }

    public String transcription(java.io.File file, AudioResponseFormatEnum audioResponseFormatEnum) {
        TranscriptionRequest transcriptionRequest = TranscriptionRequest.builder().file(file).model(AudioModelEnum.WHISPER_1.getModelName()).responseFormat(audioResponseFormatEnum.getFormat()).build();
        return this.transcription(transcriptionRequest);
    }

    public String transcription(TranscriptionRequest transcriptionRequest) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("model", transcriptionRequest.getModel()).addFormDataPart("file", transcriptionRequest.getFile().getName(), RequestBody.Companion.create(transcriptionRequest.getFile(), MediaType.parse((String)"application/octet-stream")));
        if (transcriptionRequest.getPrompt() != null) {
            builder.addFormDataPart("prompt", transcriptionRequest.getPrompt());
        }
        if (transcriptionRequest.getResponseFormat() != null) {
            builder.addFormDataPart("response_format", transcriptionRequest.getResponseFormat());
        }
        if (transcriptionRequest.getTemperature() != null) {
            builder.addFormDataPart("temperature", String.valueOf(transcriptionRequest.getTemperature()));
        }
        if (transcriptionRequest.getLanguage() != null) {
            builder.addFormDataPart("language", transcriptionRequest.getLanguage());
        }
        MultipartBody requestBody = builder.build();
        Request request = new Request.Builder().post((RequestBody)requestBody).url("https://api.openai.com/v1/audio/transcriptions").build();
        String text = null;
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try (Response response = this.client.newCall(request).execute();){
                if (i > 0) {
                    this.randomSleep();
                }
                text = response.body().string();
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("transcription failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.TRANSCRIPTION_ERROR, e.getMessage());
            }
        }
        return text;
    }

    public String translation(String filePath, AudioResponseFormatEnum audioResponseFormatEnum) {
        java.io.File file = new java.io.File(filePath);
        return this.translation(file, audioResponseFormatEnum);
    }

    public String translation(java.io.File file, AudioResponseFormatEnum audioResponseFormatEnum) {
        TranslationRequest translationRequest = TranslationRequest.builder().file(file).model(AudioModelEnum.WHISPER_1.getModelName()).responseFormat(audioResponseFormatEnum.getFormat()).build();
        return this.translation(translationRequest);
    }

    public String translation(TranslationRequest translationRequest) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("model", translationRequest.getModel()).addFormDataPart("file", translationRequest.getFile().getName(), RequestBody.Companion.create(translationRequest.getFile(), MediaType.parse((String)"application/octet-stream")));
        if (translationRequest.getPrompt() != null) {
            builder.addFormDataPart("prompt", translationRequest.getPrompt());
        }
        if (translationRequest.getResponseFormat() != null) {
            builder.addFormDataPart("response_format", translationRequest.getResponseFormat());
        }
        if (translationRequest.getTemperature() != null) {
            builder.addFormDataPart("temperature", String.valueOf(translationRequest.getTemperature()));
        }
        MultipartBody requestBody = builder.build();
        Request request = new Request.Builder().post((RequestBody)requestBody).url("https://api.openai.com/v1/audio/translations").build();
        String text = null;
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try (Response response = this.client.newCall(request).execute();){
                if (i > 0) {
                    this.randomSleep();
                }
                text = response.body().string();
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("translation failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.TRANSLATION_ERROR, e.getMessage());
            }
        }
        return text;
    }

    public ImageResult createImageEdit(CreateImageEditRequest createImageEditRequest, String imagePath, String maskPath) {
        java.io.File image = new java.io.File(imagePath);
        java.io.File mask = null;
        if (maskPath != null) {
            mask = new java.io.File(maskPath);
        }
        return this.createImageEdit(createImageEditRequest, image, mask);
    }

    public ImageResult createImageEdit(CreateImageEditRequest createImageEditRequest, java.io.File image, java.io.File mask) {
        try {
            this.convertColorFormats(image);
            if (mask != null) {
                this.convertColorFormats(mask);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
        }
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("prompt", createImageEditRequest.getPrompt()).addFormDataPart("image", image.getName(), RequestBody.Companion.create(image, MediaType.parse((String)"application/octet-stream")));
        if (mask != null) {
            builder.addFormDataPart("mask", mask.getName(), RequestBody.Companion.create(mask, MediaType.parse((String)"application/octet-stream")));
        }
        if (createImageEditRequest.getN() != null) {
            builder.addFormDataPart("n", String.valueOf(createImageEditRequest.getN()));
        }
        if (createImageEditRequest.getResponseFormat() != null) {
            builder.addFormDataPart("response_format", createImageEditRequest.getResponseFormat());
        }
        if (createImageEditRequest.getSize() != null) {
            builder.addFormDataPart("size", createImageEditRequest.getSize());
        }
        if (createImageEditRequest.getUser() != null) {
            builder.addFormDataPart("user", createImageEditRequest.getUser());
        }
        MultipartBody requestBody = builder.build();
        Request request = new Request.Builder().post((RequestBody)requestBody).url("https://api.openai.com/v1/images/edits").build();
        ImageResult imageResult = new ImageResult();
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try (Response response = this.client.newCall(request).execute();){
                if (i > 0) {
                    this.randomSleep();
                }
                String res = response.body().string();
                imageResult = (ImageResult)JSONObject.parseObject((String)res, ImageResult.class);
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("create image edit failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.CREATE_IMAGE_EDIT_ERROR, e.getMessage());
            }
        }
        return imageResult;
    }

    public ImageResult createImageVariation(CreateImageVariationRequest createImageVariationRequest, String imagePath) {
        java.io.File image = new java.io.File(imagePath);
        return this.createImageVariation(createImageVariationRequest, image);
    }

    public ImageResult createImageVariation(CreateImageVariationRequest createImageVariationRequest, java.io.File image) {
        try {
            this.convertColorFormats(image);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
        }
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("image", image.getName(), RequestBody.Companion.create(image, MediaType.parse((String)"application/octet-stream")));
        if (createImageVariationRequest.getN() != null) {
            builder.addFormDataPart("n", String.valueOf(createImageVariationRequest.getN()));
        }
        if (createImageVariationRequest.getResponseFormat() != null) {
            builder.addFormDataPart("response_format", createImageVariationRequest.getResponseFormat());
        }
        if (createImageVariationRequest.getSize() != null) {
            builder.addFormDataPart("size", createImageVariationRequest.getSize());
        }
        if (createImageVariationRequest.getUser() != null) {
            builder.addFormDataPart("user", createImageVariationRequest.getUser());
        }
        MultipartBody requestBody = builder.build();
        Request request = new Request.Builder().post((RequestBody)requestBody).url("https://api.openai.com/v1/images/variations").build();
        ImageResult imageResult = new ImageResult();
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try (Response response = this.client.newCall(request).execute();){
                if (i > 0) {
                    this.randomSleep();
                }
                String res = response.body().string();
                imageResult = (ImageResult)JSONObject.parseObject((String)res, ImageResult.class);
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("create image variation failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.CREATE_IMAGE_VARIATION_ERROR, e.getMessage());
            }
        }
        return imageResult;
    }

    public List<File> listFiles() {
        List<Object> files = new ArrayList<File>();
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    this.randomSleep();
                }
                files = super.listFiles();
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("list files failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.LIST_FILES_ERROR, e.getMessage());
            }
        }
        return files;
    }

    public File uploadFile(@NonNull String purpose, @NonNull String filepath) {
        if (purpose == null) {
            throw new NullPointerException("purpose is marked non-null but is null");
        }
        if (filepath == null) {
            throw new NullPointerException("filepath is marked non-null but is null");
        }
        File file = null;
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    this.randomSleep();
                }
                file = super.uploadFile(purpose, filepath);
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("upload file failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.UPLOAD_FILE_ERROR, e.getMessage());
            }
        }
        return file;
    }

    public DeleteResult deleteFile(@NonNull String fileId) {
        if (fileId == null) {
            throw new NullPointerException("fileId is marked non-null but is null");
        }
        DeleteResult deleteResult = null;
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    this.randomSleep();
                }
                deleteResult = super.deleteFile(fileId);
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("delete file failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.DELETE_FILE_ERROR, e.getMessage());
            }
        }
        return deleteResult;
    }

    public File retrieveFile(@NonNull String fileId) {
        if (fileId == null) {
            throw new NullPointerException("fileId is marked non-null but is null");
        }
        File file = null;
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    this.randomSleep();
                }
                file = super.retrieveFile(fileId);
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("retrieve file failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.RETRIEVE_FILE_ERROR, e.getMessage());
            }
        }
        return file;
    }

    public String retrieveFileContent(@NonNull String fileId) {
        if (fileId == null) {
            throw new NullPointerException("fileId is marked non-null but is null");
        }
        Request request = new Request.Builder().url("https://api.openai.com/v1/files/{" + fileId + "}/content").build();
        String fileContent = null;
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try (Response response = this.client.newCall(request).execute();){
                if (i > 0) {
                    this.randomSleep();
                }
                fileContent = response.body().string();
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("retrieve file content failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.RETRIEVE_FILE_CONTENT_ERROR, e.getMessage());
            }
        }
        return fileContent;
    }

    public FineTuneResult createFineTune(FineTuneRequest fineTuneRequest) {
        FineTuneResult fineTuneResult = new FineTuneResult();
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    this.randomSleep();
                }
                fineTuneResult = super.createFineTune(fineTuneRequest);
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("create fine tune failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.CREATE_FINE_TUNE_ERROR, e.getMessage());
            }
        }
        return fineTuneResult;
    }

    public CompletionResult createFineTuneCompletion(CompletionRequest completionRequest) {
        CompletionResult completionResult = new CompletionResult();
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    this.randomSleep();
                }
                completionResult = super.createFineTuneCompletion(completionRequest);
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("create fine tune completion failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.CREATE_FINE_TUNE_COMPLETION_ERROR, e.getMessage());
            }
        }
        return completionResult;
    }

    public List<FineTuneResult> listFineTunes() {
        List<Object> fineTunes = new ArrayList<FineTuneResult>();
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    this.randomSleep();
                }
                fineTunes = super.listFineTunes();
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("list fine tunes failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.LIST_FINE_TUNES_ERROR, e.getMessage());
            }
        }
        return fineTunes;
    }

    public FineTuneResult retrieveFineTune(String fineTuneId) {
        FineTuneResult fineTuneResult = new FineTuneResult();
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    this.randomSleep();
                }
                fineTuneResult = super.retrieveFineTune(fineTuneId);
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("retrieve fine tune failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.RETRIEVE_FINE_TUNE_ERROR, e.getMessage());
            }
        }
        return fineTuneResult;
    }

    public FineTuneResult cancelFineTune(String fineTuneId) {
        FineTuneResult fineTuneResult = new FineTuneResult();
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    this.randomSleep();
                }
                fineTuneResult = super.cancelFineTune(fineTuneId);
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("cancel fine tune failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.CANCEL_FINE_TUNE_ERROR, e.getMessage());
            }
        }
        return fineTuneResult;
    }

    public List<FineTuneEvent> listFineTuneEvents(String fineTuneId) {
        List<Object> fineTuneEvents = new ArrayList<FineTuneEvent>();
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    this.randomSleep();
                }
                fineTuneEvents = super.listFineTuneEvents(fineTuneId);
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("list fine tune events failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.LIST_FINE_TUNE_EVENTS_ERROR, e.getMessage());
            }
        }
        return fineTuneEvents;
    }

    public DeleteResult deleteFineTune(String fineTuneId) {
        DeleteResult deleteResult = new DeleteResult();
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    this.randomSleep();
                }
                deleteResult = super.deleteFineTune(fineTuneId);
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("delete fine tune failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.DELETE_FINE_TUNE_ERROR, e.getMessage());
            }
        }
        return deleteResult;
    }

    public ModerationResult createModeration(ModerationRequest moderationRequest) {
        ModerationResult moderationResult = new ModerationResult();
        for (int i = 0; i < this.chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    this.randomSleep();
                }
                moderationResult = super.createModeration(moderationRequest);
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("create moderation failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != this.chatGPTProperties.getRetries() - 1) continue;
                e.printStackTrace();
                throw new ChatGPTException(ChatGPTErrorEnum.CREATE_MODERATION_ERROR, e.getMessage());
            }
        }
        return moderationResult;
    }

    public void forceClearCache(String cacheName) {
        this.cache.invalidate((Object)cacheName);
    }

    public Cache<String, LinkedList<ChatMessage>> retrieveCache() {
        return this.cache;
    }

    public LinkedList<ChatMessage> retrieveChatMessage(String key) {
        return (LinkedList)this.cache.getIfPresent((Object)key);
    }

    public void setCache(Cache<String, LinkedList<ChatMessage>> cache) {
        this.cache = cache;
    }

    public void addCache(String key, LinkedList<ChatMessage> chatMessages) {
        this.cache.put((Object)key, chatMessages);
    }

    private void randomSleep() throws InterruptedException {
        Thread.sleep(500 + RANDOM.nextInt(200));
    }

    private static boolean checkTokenUsage(String message) {
        return message != null && message.contains("This model's maximum context length is");
    }

    private BufferedImage getImageFromBase64(String base64) throws IOException {
        byte[] imageBytes = Base64.getDecoder().decode(base64.getBytes());
        try (ByteArrayInputStream bis = new ByteArrayInputStream(imageBytes);){
            BufferedImage bufferedImage = ImageIO.read(bis);
            return bufferedImage;
        }
    }

    private void convertColorFormats(java.io.File image) throws IOException {
        boolean isLA;
        BufferedImage inputImage = ImageIO.read(image);
        ComponentColorModel componentColorModel = (ComponentColorModel)inputImage.getColorModel();
        int pixelSize = componentColorModel.getPixelSize();
        int numComponents = componentColorModel.getNumComponents();
        boolean isRGBA = pixelSize == 32 && numComponents == 4;
        boolean isL = pixelSize == 8 && numComponents == 1;
        boolean bl = isLA = pixelSize == 16 && numComponents == 2;
        if (!(isRGBA || isL || isLA)) {
            BufferedImage outputImage = new BufferedImage(inputImage.getWidth(), inputImage.getHeight(), 2);
            Graphics2D g2d = outputImage.createGraphics();
            g2d.drawImage((Image)inputImage, 0, 0, null);
            g2d.dispose();
            ImageIO.write((RenderedImage)outputImage, "png", image);
        }
    }
}

