/*
 * Decompiled with CFR 0.152.
 */
package io.github.asleepyfish.util;

import com.google.common.cache.Cache;
import com.theokanning.openai.DeleteResult;
import com.theokanning.openai.completion.CompletionRequest;
import com.theokanning.openai.completion.CompletionResult;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.edit.EditRequest;
import com.theokanning.openai.edit.EditResult;
import com.theokanning.openai.embedding.EmbeddingRequest;
import com.theokanning.openai.embedding.EmbeddingResult;
import com.theokanning.openai.file.File;
import com.theokanning.openai.finetune.FineTuneEvent;
import com.theokanning.openai.finetune.FineTuneRequest;
import com.theokanning.openai.finetune.FineTuneResult;
import com.theokanning.openai.image.CreateImageEditRequest;
import com.theokanning.openai.image.CreateImageRequest;
import com.theokanning.openai.image.CreateImageVariationRequest;
import com.theokanning.openai.image.ImageResult;
import com.theokanning.openai.model.Model;
import com.theokanning.openai.moderation.ModerationRequest;
import com.theokanning.openai.moderation.ModerationResult;
import io.github.asleepyfish.entity.audio.TranscriptionRequest;
import io.github.asleepyfish.entity.audio.TranslationRequest;
import io.github.asleepyfish.entity.billing.Billing;
import io.github.asleepyfish.entity.billing.Subscription;
import io.github.asleepyfish.enums.audio.AudioResponseFormatEnum;
import io.github.asleepyfish.enums.chat.RoleEnum;
import io.github.asleepyfish.enums.edit.EditModelEnum;
import io.github.asleepyfish.enums.embedding.EmbeddingModelEnum;
import io.github.asleepyfish.enums.image.ImageResponseFormatEnum;
import io.github.asleepyfish.enums.image.ImageSizeEnum;
import io.github.asleepyfish.enums.model.ModelEnum;
import io.github.asleepyfish.service.OpenAiProxyService;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenAiUtils {
    private static final Log LOG = LogFactory.getLog(OpenAiUtils.class);
    private static OpenAiProxyService openAiProxyService;

    public OpenAiUtils(OpenAiProxyService openAiProxyService) {
        OpenAiUtils.openAiProxyService = openAiProxyService;
    }

    public static void createStreamChatCompletion(String content) {
        OpenAiUtils.createStreamChatCompletion(content, "DEFAULT USER", System.out);
    }

    public static void createStreamChatCompletion(String content, OutputStream os) {
        OpenAiUtils.createStreamChatCompletion(content, "DEFAULT USER", os);
    }

    public static void createStreamChatCompletion(String content, String user, OutputStream os) {
        openAiProxyService.createStreamChatCompletion(content, user, os);
    }

    public static void createStreamChatCompletion(String content, String user, String model, OutputStream os) {
        OpenAiUtils.createStreamChatCompletion(RoleEnum.USER.getRoleName(), content, user, model, 1.0, 1.0, os);
    }

    public static void createStreamChatCompletion(String role, String content, String user, String model, Double temperature, Double topP, OutputStream os) {
        OpenAiUtils.createStreamChatCompletion(ChatCompletionRequest.builder().model(model).messages(Collections.singletonList(new ChatMessage(role, content))).user(user).temperature(temperature).topP(topP).stream(Boolean.valueOf(true)).build(), os);
    }

    public static void createStreamChatCompletion(ChatCompletionRequest chatCompletionRequest, OutputStream os) {
        openAiProxyService.createStreamChatCompletion(chatCompletionRequest, os);
    }

    public static List<String> createChatCompletion(String content) {
        return OpenAiUtils.createChatCompletion(content, "DEFAULT USER");
    }

    public static List<String> createChatCompletion(String content, String user) {
        return openAiProxyService.chatCompletion(content, user);
    }

    public static List<String> createChatCompletion(String content, String user, String model) {
        return OpenAiUtils.createChatCompletion(RoleEnum.USER.getRoleName(), content, user, model, 1.0, 1.0);
    }

    public static List<String> createChatCompletion(String role, String content, String user, String model, Double temperature, Double topP) {
        return OpenAiUtils.createChatCompletion(ChatCompletionRequest.builder().model(model).messages(Collections.singletonList(new ChatMessage(role, content))).user(user).temperature(temperature).topP(topP).build());
    }

    public static List<String> createChatCompletion(ChatCompletionRequest chatCompletionRequest) {
        return openAiProxyService.chatCompletion(chatCompletionRequest);
    }

    @Deprecated
    public static List<String> createCompletion(String prompt) {
        return OpenAiUtils.createCompletion(prompt, "DEFAULT USER");
    }

    @Deprecated
    public static List<String> createCompletion(String prompt, String user) {
        return openAiProxyService.completion(prompt, user);
    }

    @Deprecated
    public static List<String> createCompletion(String prompt, String user, String model) {
        return OpenAiUtils.createCompletion(prompt, user, model, 0.0, 1.0);
    }

    @Deprecated
    public static List<String> createCompletion(String prompt, String user, String model, Double temperature, Double topP) {
        return OpenAiUtils.createCompletion(CompletionRequest.builder().model(model).prompt(prompt).user(user).temperature(temperature).topP(topP).maxTokens(ModelEnum.getMaxTokens(model)).build());
    }

    @Deprecated
    public static List<String> createCompletion(CompletionRequest completionRequest) {
        return openAiProxyService.completion(completionRequest);
    }

    public static List<String> createImage(String prompt) {
        return OpenAiUtils.createImage(prompt, "DEFAULT USER");
    }

    public static List<String> createImage(String prompt, String user) {
        return openAiProxyService.createImages(prompt, user);
    }

    public static List<String> createImages(String prompt, String user, ImageResponseFormatEnum responseFormat) {
        return openAiProxyService.createImages(prompt, user, responseFormat);
    }

    public static ImageResult createImage(CreateImageRequest createImageRequest) {
        return openAiProxyService.createImages(createImageRequest);
    }

    public static void downloadImage(String prompt, HttpServletResponse response) {
        OpenAiUtils.downloadImage(prompt, ImageSizeEnum.S1024x1024.getSize(), response);
    }

    public static void downloadImage(String prompt, Integer n, HttpServletResponse response) {
        OpenAiUtils.downloadImage(prompt, n, ImageSizeEnum.S1024x1024.getSize(), response);
    }

    public static void downloadImage(String prompt, String size, HttpServletResponse response) {
        OpenAiUtils.downloadImage(prompt, 1, size, response);
    }

    public static void downloadImage(String prompt, Integer n, String size, HttpServletResponse response) {
        OpenAiUtils.downloadImage(CreateImageRequest.builder().prompt(prompt).n(n).size(size).user("DEFAULT USER").build(), response);
    }

    public static void downloadImage(CreateImageRequest createImageRequest, HttpServletResponse response) {
        openAiProxyService.downloadImage(createImageRequest, response);
    }

    public static String billingUsage(String ... startDate) {
        return openAiProxyService.billingUsage(startDate);
    }

    public static String billingUsage(String startDate, String endDate) {
        return openAiProxyService.billingUsage(startDate, endDate);
    }

    public static Billing billing(String ... startDate) {
        return openAiProxyService.billing(startDate);
    }

    public static Subscription subscription() {
        return openAiProxyService.subscription();
    }

    public static List<Model> listModels() {
        return openAiProxyService.listModels();
    }

    public static Model getModel(String model) {
        return openAiProxyService.getModel(model);
    }

    public static String edit(String input, String instruction) {
        return openAiProxyService.edit(input, instruction);
    }

    public static String edit(String input, String instruction, EditModelEnum editModelEnum) {
        return openAiProxyService.edit(input, instruction, editModelEnum);
    }

    public static String edit(String input, String instruction, Double temperature, Double topP, EditModelEnum editModelEnum) {
        return openAiProxyService.edit(input, instruction, temperature, topP, editModelEnum);
    }

    public static EditResult edit(EditRequest editRequest) {
        return openAiProxyService.edit(editRequest);
    }

    public static List<Double> embeddings(String text) {
        return openAiProxyService.embeddings(text);
    }

    public static List<Double> embeddings(String text, EmbeddingModelEnum embeddingModelEnum) {
        return openAiProxyService.embeddings(text, embeddingModelEnum);
    }

    public static EmbeddingResult embeddings(EmbeddingRequest embeddingRequest) {
        return openAiProxyService.embeddings(embeddingRequest);
    }

    public static String transcription(String filePath, AudioResponseFormatEnum audioResponseFormatEnum) {
        return openAiProxyService.transcription(filePath, audioResponseFormatEnum);
    }

    public static String transcription(java.io.File file, AudioResponseFormatEnum audioResponseFormatEnum) {
        return openAiProxyService.transcription(file, audioResponseFormatEnum);
    }

    public static String transcription(TranscriptionRequest transcriptionRequest) {
        return openAiProxyService.transcription(transcriptionRequest);
    }

    public static String translation(String filePath, AudioResponseFormatEnum audioResponseFormatEnum) {
        return openAiProxyService.translation(filePath, audioResponseFormatEnum);
    }

    public static String translation(java.io.File file, AudioResponseFormatEnum audioResponseFormatEnum) {
        return openAiProxyService.translation(file, audioResponseFormatEnum);
    }

    public static String translation(TranslationRequest translationRequest) {
        return openAiProxyService.translation(translationRequest);
    }

    public static ImageResult createImageEdit(CreateImageEditRequest createImageEditRequest, String imagePath, String maskPath) {
        return openAiProxyService.createImageEdit(createImageEditRequest, imagePath, maskPath);
    }

    public static ImageResult createImageEdit(CreateImageEditRequest createImageEditRequest, java.io.File image, java.io.File mask) {
        return openAiProxyService.createImageEdit(createImageEditRequest, image, mask);
    }

    public static ImageResult createImageVariation(CreateImageVariationRequest createImageVariationRequest, String imagePath) {
        return openAiProxyService.createImageVariation(createImageVariationRequest, imagePath);
    }

    public static ImageResult createImageVariation(CreateImageVariationRequest createImageVariationRequest, java.io.File image) {
        return openAiProxyService.createImageVariation(createImageVariationRequest, image);
    }

    public static List<File> listFiles() {
        return openAiProxyService.listFiles();
    }

    public static File uploadFile(@NonNull String purpose, @NonNull String filepath) {
        if (purpose == null) {
            throw new NullPointerException("purpose is marked non-null but is null");
        }
        if (filepath == null) {
            throw new NullPointerException("filepath is marked non-null but is null");
        }
        return openAiProxyService.uploadFile(purpose, filepath);
    }

    public static DeleteResult deleteFile(@NonNull String fileId) {
        if (fileId == null) {
            throw new NullPointerException("fileId is marked non-null but is null");
        }
        return openAiProxyService.deleteFile(fileId);
    }

    public static File retrieveFile(@NonNull String fileId) {
        if (fileId == null) {
            throw new NullPointerException("fileId is marked non-null but is null");
        }
        return openAiProxyService.retrieveFile(fileId);
    }

    public static String retrieveFileContent(@NonNull String fileId) {
        if (fileId == null) {
            throw new NullPointerException("fileId is marked non-null but is null");
        }
        return openAiProxyService.retrieveFileContent(fileId);
    }

    public static FineTuneResult createFineTune(FineTuneRequest FineTuneRequest2) {
        return openAiProxyService.createFineTune(FineTuneRequest2);
    }

    public static CompletionResult createFineTuneCompletion(CompletionRequest completionRequest) {
        return openAiProxyService.createFineTuneCompletion(completionRequest);
    }

    public static List<FineTuneResult> listFineTunes() {
        return openAiProxyService.listFineTunes();
    }

    public static FineTuneResult retrieveFineTune(String fineTuneId) {
        return openAiProxyService.retrieveFineTune(fineTuneId);
    }

    public static FineTuneResult cancelFineTune(String fineTuneId) {
        return openAiProxyService.cancelFineTune(fineTuneId);
    }

    public static List<FineTuneEvent> listFineTuneEvents(String fineTuneId) {
        return openAiProxyService.listFineTuneEvents(fineTuneId);
    }

    public static DeleteResult deleteFineTune(String fineTuneId) {
        return openAiProxyService.deleteFineTune(fineTuneId);
    }

    public static ModerationResult createModeration(ModerationRequest moderationRequest) {
        return openAiProxyService.createModeration(moderationRequest);
    }

    public static void forceClearCache(String cacheName) {
        openAiProxyService.forceClearCache(cacheName);
    }

    public static Cache<String, LinkedList<ChatMessage>> retrieveCache() {
        return openAiProxyService.retrieveCache();
    }

    public static LinkedList<ChatMessage> retrieveChatMessage(String key) {
        return openAiProxyService.retrieveChatMessage(key);
    }

    public static void setCache(Cache<String, LinkedList<ChatMessage>> cache) {
        openAiProxyService.setCache(cache);
    }

    public static void addCache(String key, LinkedList<ChatMessage> chatMessages) {
        openAiProxyService.addCache(key, chatMessages);
    }
}

