/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.instantiation;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java8.util.J8Arrays;
import java8.util.stream.Collectors;
import java8.util.stream.StreamSupport;
import org.astonbitecode.j4rs.api.Instance;
import org.astonbitecode.j4rs.api.dtos.GeneratedArg;
import org.astonbitecode.j4rs.api.dtos.InvocationArg;
import org.astonbitecode.j4rs.api.dtos.InvocationArgGenerator;
import org.astonbitecode.j4rs.api.instantiation.NativeInstantiationImpl$$Lambda$1;
import org.astonbitecode.j4rs.api.instantiation.NativeInstantiationImpl$$Lambda$10;
import org.astonbitecode.j4rs.api.instantiation.NativeInstantiationImpl$$Lambda$11;
import org.astonbitecode.j4rs.api.instantiation.NativeInstantiationImpl$$Lambda$12;
import org.astonbitecode.j4rs.api.instantiation.NativeInstantiationImpl$$Lambda$2;
import org.astonbitecode.j4rs.api.instantiation.NativeInstantiationImpl$$Lambda$3;
import org.astonbitecode.j4rs.api.instantiation.NativeInstantiationImpl$$Lambda$4;
import org.astonbitecode.j4rs.api.instantiation.NativeInstantiationImpl$$Lambda$5;
import org.astonbitecode.j4rs.api.instantiation.NativeInstantiationImpl$$Lambda$6;
import org.astonbitecode.j4rs.api.instantiation.NativeInstantiationImpl$$Lambda$7;
import org.astonbitecode.j4rs.api.instantiation.NativeInstantiationImpl$$Lambda$8;
import org.astonbitecode.j4rs.api.instantiation.NativeInstantiationImpl$$Lambda$9;
import org.astonbitecode.j4rs.api.invocation.InstanceGenerator;
import org.astonbitecode.j4rs.api.invocation.JsonInvocationImpl;
import org.astonbitecode.j4rs.errors.InstantiationException;
import org.astonbitecode.j4rs.utils.Utils;

public class NativeInstantiationImpl {
    static InvocationArgGenerator gen = new InvocationArgGenerator();

    public static Instance instantiate(String className, InvocationArg ... args) {
        try {
            CreatedInstance createdInstance = NativeInstantiationImpl.createInstance(className, NativeInstantiationImpl.generateArgObjects(args));
            return InstanceGenerator.create(createdInstance.object, createdInstance.clazz);
        }
        catch (Exception error) {
            throw new InstantiationException("Cannot create instance of " + className, error);
        }
    }

    public static Instance createForStatic(String className) {
        try {
            Class<?> clazz = Utils.forNameEnhanced(className);
            return InstanceGenerator.create(clazz);
        }
        catch (Exception error) {
            throw new InstantiationException("Cannot create instance of " + className, error);
        }
    }

    public static Instance createJavaArray(String className, InvocationArg ... args) {
        try {
            CreatedInstance createdInstance = NativeInstantiationImpl.createCollection(className, NativeInstantiationImpl.generateArgObjects(args), J4rsCollectionType.Array);
            return new JsonInvocationImpl<Object>(createdInstance.object, createdInstance.clazz);
        }
        catch (Exception error) {
            throw new InstantiationException("Cannot create Java Array of " + className, error);
        }
    }

    public static Instance createJavaList(String className, InvocationArg ... args) {
        try {
            CreatedInstance createdInstance = NativeInstantiationImpl.createCollection(className, NativeInstantiationImpl.generateArgObjects(args), J4rsCollectionType.List);
            return new JsonInvocationImpl<Object>(createdInstance.object, createdInstance.clazz);
        }
        catch (Exception error) {
            throw new InstantiationException("Cannot create Java List of " + className, error);
        }
    }

    static GeneratedArg[] generateArgObjects(InvocationArg[] args) throws Exception {
        return gen.generateArgObjects(args);
    }

    static CreatedInstance createInstance(String className, GeneratedArg[] params) throws Exception {
        Class<?> clazz = Utils.forNameEnhanced(className);
        Class[] paramTypes = (Class[])J8Arrays.stream((Object[])params).map(NativeInstantiationImpl$$Lambda$1.lambdaFactory$()).toArray(NativeInstantiationImpl$$Lambda$2.lambdaFactory$());
        Object[] paramObjects = J8Arrays.stream((Object[])params).map(NativeInstantiationImpl$$Lambda$3.lambdaFactory$()).toArray(NativeInstantiationImpl$$Lambda$4.lambdaFactory$());
        Constructor<?> constructor = NativeInstantiationImpl.findConstructor(clazz, paramTypes);
        Object instance = constructor.newInstance(paramObjects);
        return new CreatedInstance(clazz, instance);
    }

    private static Constructor<?> findConstructor(Class clazz, Class[] argTypes) throws NoSuchMethodException {
        List found = (List)J8Arrays.stream((Object[])clazz.getConstructors()).filter(NativeInstantiationImpl$$Lambda$5.lambdaFactory$(argTypes)).filter(NativeInstantiationImpl$$Lambda$6.lambdaFactory$(argTypes)).collect(Collectors.toList());
        if (!found.isEmpty()) {
            return (Constructor)found.get(0);
        }
        Class superclass = clazz.getSuperclass();
        if (superclass == null) {
            throw new NoSuchMethodException("Constructor was not found in " + clazz.getName() + " or its ancestors.");
        }
        return NativeInstantiationImpl.findConstructor(superclass, argTypes);
    }

    static CreatedInstance createCollection(String className, GeneratedArg[] params, J4rsCollectionType collectionType) throws Exception {
        boolean isJ4rsArray = className.equals("org.astonbitecode.j4rs.api.dtos.Array");
        Class<?> clazz = isJ4rsArray ? Utils.forNameBasedOnArgs(params) : Utils.forNameEnhanced(className);
        List<Object> arrayObj = Array.newInstance(clazz, params.length);
        Object[] paramTypes = (Class[])J8Arrays.stream((Object[])params).map(NativeInstantiationImpl$$Lambda$7.lambdaFactory$()).toArray(NativeInstantiationImpl$$Lambda$8.lambdaFactory$());
        if (!isJ4rsArray && !J8Arrays.stream((Object[])paramTypes).allMatch(NativeInstantiationImpl$$Lambda$9.lambdaFactory$(className))) {
            throw new IllegalArgumentException("Could not create Java array. All the arguments should be of class " + className);
        }
        Object[] paramObjects = J8Arrays.stream((Object[])params).map(NativeInstantiationImpl$$Lambda$10.lambdaFactory$()).toArray(NativeInstantiationImpl$$Lambda$11.lambdaFactory$());
        for (int i = 0; i < params.length; ++i) {
            Array.set(arrayObj, i, paramObjects[i]);
        }
        switch (collectionType) {
            case Array: {
                return new CreatedInstance(arrayObj.getClass(), arrayObj);
            }
            case List: {
                List<Object> l = clazz.isPrimitive() ? arrayObj : Arrays.asList((Object[])arrayObj);
                return new CreatedInstance(l.getClass(), l);
            }
        }
        return new CreatedInstance(arrayObj.getClass(), arrayObj);
    }

    static /* synthetic */ Object[] lambda$createCollection$10(int size) {
        return new Object[size];
    }

    static /* synthetic */ Object lambda$createCollection$9(GeneratedArg param) {
        return param.getObject();
    }

    static /* synthetic */ boolean lambda$createCollection$8(String className, Class type) {
        return type.getName().equals(className);
    }

    static /* synthetic */ Class[] lambda$createCollection$7(int size) {
        return new Class[size];
    }

    static /* synthetic */ Class lambda$createCollection$6(GeneratedArg param) {
        return param.getClazz();
    }

    static /* synthetic */ boolean lambda$findConstructor$5(Class[] argTypes, Constructor constructor) {
        ArrayList<Boolean> matchedParams = new ArrayList<Boolean>();
        Type[] pts = constructor.getGenericParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            Type typ = pts[i];
            if (typ instanceof ParameterizedType || typ instanceof WildcardType) {
                matchedParams.add(true);
                continue;
            }
            if (typ instanceof GenericArrayType) {
                matchedParams.add(argTypes[i].isArray());
                continue;
            }
            if (typ instanceof Class) {
                matchedParams.add(((Class)typ).isAssignableFrom(argTypes[i]));
                continue;
            }
            matchedParams.add(true);
        }
        return StreamSupport.stream(matchedParams).allMatch(NativeInstantiationImpl$$Lambda$12.lambdaFactory$());
    }

    static /* synthetic */ boolean lambda$findConstructor$4(Class[] argTypes, Constructor constructor) {
        return constructor.getGenericParameterTypes().length == argTypes.length;
    }

    static /* synthetic */ Object[] lambda$createInstance$3(int size) {
        return new Object[size];
    }

    static /* synthetic */ Object lambda$createInstance$2(GeneratedArg param) {
        return param.getObject();
    }

    static /* synthetic */ Class[] lambda$createInstance$1(int size) {
        return new Class[size];
    }

    static /* synthetic */ Class lambda$createInstance$0(GeneratedArg param) {
        return param.getClazz();
    }

    static enum J4rsCollectionType {
        Array,
        List;

    }

    static class CreatedInstance {
        private Class clazz;
        private Object object;

        public CreatedInstance(Class clazz, Object object) {
            this.clazz = clazz;
            this.object = object;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

