/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.invocation;

import java.util.Optional;
import org.astonbitecode.j4rs.api.Instance;
import org.astonbitecode.j4rs.api.invocation.InstanceGenerator;
import org.astonbitecode.j4rs.errors.InvocationException;
import org.astonbitecode.j4rs.rust.RustPointer;

public class NativeCallbackSupport {
    private Optional<RustPointer> functionPointerOpt = Optional.empty();

    private static native void docallback(long var0, Instance var2);

    static void initialize(String libname) throws UnsatisfiedLinkError {
        System.loadLibrary(libname);
    }

    protected void doCallback(Object obj) {
        if (!this.functionPointerOpt.isPresent() || obj == null) {
            throw new InvocationException("Cannot do callback. Please make sure that you don't try to access this method while being in the constructor of your class (that extends NativeCallbackSupport)");
        }
        NativeCallbackSupport.docallback(this.functionPointerOpt.get().getAddress(), InstanceGenerator.create(obj, obj.getClass()));
    }

    final void initPointer(RustPointer p) {
        this.functionPointerOpt = Optional.of(p);
    }
}

