/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.dtos;

import org.astonbitecode.j4rs.api.Instance;
import org.astonbitecode.j4rs.api.invocation.JsonInvocationImpl;
import org.astonbitecode.j4rs.errors.InvalidArgumentException;
import org.astonbitecode.j4rs.utils.Utils;

public class InvocationArg
implements Instance {
    public static final String CONTENTS_ARRAY = "org.astonbitecode.j4rs.api.dtos.Array";
    private final Instance instance;
    private final String json;
    private boolean serialized;
    private String className;

    public InvocationArg(String className, Instance instance) {
        this.json = null;
        this.className = className;
        this.instance = instance;
        this.serialized = false;
    }

    public InvocationArg(Instance instance) {
        this.json = null;
        this.className = instance.getClass().getName();
        this.instance = instance;
        this.serialized = false;
    }

    public InvocationArg(String className, String json) {
        this.instance = null;
        this.className = className;
        this.json = json;
        this.serialized = true;
    }

    public InvocationArg(String className, Object object) throws ClassNotFoundException {
        this.instance = new JsonInvocationImpl<Object>(object, Utils.forNameEnhanced(className));
        this.className = className;
        this.json = null;
        this.serialized = false;
    }

    public boolean isSerialized() {
        return this.serialized;
    }

    @Override
    public String getObjectClassName() {
        return this.className;
    }

    public Instance getInstance() {
        if (this.isSerialized()) {
            throw new InvalidArgumentException("This InvocationArg of class " + this.className + " is created by Rust code.");
        }
        return this.instance;
    }

    @Override
    public String getJson() {
        if (!this.isSerialized()) {
            throw new InvalidArgumentException("This InvocationArg of class " + this.className + " is created by Java code.");
        }
        return this.json;
    }

    public String toString() {
        return "classname:" + this.className + ", serialized:" + this.serialized + ", json:" + this.json + ", instance:" + this.instance;
    }

    @Override
    public Object getObject() {
        return this.getInstance() != null ? this.getInstance().getObject() : null;
    }

    @Override
    public Class<?> getObjectClass() {
        return this.getInstance() != null ? this.getInstance().getObjectClass() : null;
    }

    @Override
    public Instance invoke(String methodName, InvocationArg ... args) {
        return this.getInstance() != null ? this.getInstance().invoke(methodName, args) : null;
    }

    @Override
    public Instance invokeStatic(String methodName, InvocationArg ... args) {
        return this.getInstance() != null ? this.getInstance().invokeStatic(methodName, args) : null;
    }

    @Override
    public void invokeAsyncToChannel(long channelAddress, String methodName, InvocationArg ... args) {
        if (this.getInstance() != null) {
            this.getInstance().invokeAsyncToChannel(channelAddress, methodName, args);
        }
    }

    @Override
    public void invokeToChannel(long channelAddress, String methodName, InvocationArg ... args) {
        if (this.getInstance() != null) {
            this.getInstance().invokeToChannel(channelAddress, methodName, args);
        }
    }

    @Override
    public void initializeCallbackChannel(long channelAddress) {
        if (this.getInstance() != null) {
            this.getInstance().initializeCallbackChannel(channelAddress);
        }
    }

    @Override
    public Instance field(String fieldName) {
        return this.getInstance() != null ? this.getInstance().field(fieldName) : null;
    }
}

