/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.instantiation;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.astonbitecode.j4rs.api.Instance;
import org.astonbitecode.j4rs.api.dtos.GeneratedArg;
import org.astonbitecode.j4rs.api.dtos.InvocationArg;
import org.astonbitecode.j4rs.api.dtos.InvocationArgGenerator;
import org.astonbitecode.j4rs.api.invocation.InstanceGenerator;
import org.astonbitecode.j4rs.api.invocation.JsonInvocationImpl;
import org.astonbitecode.j4rs.errors.InstantiationException;
import org.astonbitecode.j4rs.utils.Utils;

public class NativeInstantiationImpl {
    static InvocationArgGenerator gen = new InvocationArgGenerator();

    public static Instance instantiate(String className, InvocationArg ... args) {
        try {
            CreatedInstance createdInstance = NativeInstantiationImpl.createInstance(className, NativeInstantiationImpl.generateArgObjects(args));
            return InstanceGenerator.create(createdInstance.object, createdInstance.clazz);
        }
        catch (Exception error) {
            throw new InstantiationException("Cannot create instance of " + className, error);
        }
    }

    public static Instance createForStatic(String className) {
        try {
            Class<?> clazz = Utils.forNameEnhanced(className);
            return InstanceGenerator.create(clazz);
        }
        catch (Exception error) {
            throw new InstantiationException("Cannot create instance of " + className, error);
        }
    }

    public static Instance createJavaArray(String className, InvocationArg ... args) {
        try {
            CreatedInstance createdInstance = NativeInstantiationImpl.createCollection(className, NativeInstantiationImpl.generateArgObjects(args), J4rsCollectionType.Array);
            return new JsonInvocationImpl<Object>(createdInstance.object, createdInstance.clazz);
        }
        catch (Exception error) {
            throw new InstantiationException("Cannot create Java Array of " + className, error);
        }
    }

    public static Instance createJavaList(String className, InvocationArg ... args) {
        try {
            CreatedInstance createdInstance = NativeInstantiationImpl.createCollection(className, NativeInstantiationImpl.generateArgObjects(args), J4rsCollectionType.List);
            return new JsonInvocationImpl<Object>(createdInstance.object, createdInstance.clazz);
        }
        catch (Exception error) {
            throw new InstantiationException("Cannot create Java List of " + className, error);
        }
    }

    public static Instance createJavaMap(String keyClassName, String valueClassName, InvocationArg ... args) {
        try {
            CreatedInstance createdInstance = NativeInstantiationImpl.createMap(keyClassName, valueClassName, NativeInstantiationImpl.generateArgObjects(args));
            return new JsonInvocationImpl<Object>(createdInstance.object, createdInstance.clazz);
        }
        catch (Exception error) {
            throw new InstantiationException(String.format("Cannot create Java Map of keys %s and values %s", keyClassName, valueClassName), error);
        }
    }

    static GeneratedArg[] generateArgObjects(InvocationArg[] args) throws Exception {
        return gen.generateArgObjects(args);
    }

    static CreatedInstance createInstance(String className, GeneratedArg[] params) throws Exception {
        Class<?> clazz = Utils.forNameEnhanced(className);
        Class[] paramTypes = (Class[])Arrays.stream(params).map(param -> param.getClazz()).toArray(Class[]::new);
        Object[] paramObjects = Arrays.stream(params).map(param -> param.getObject()).toArray(Object[]::new);
        Constructor<?> constructor = NativeInstantiationImpl.findConstructor(clazz, paramTypes);
        Object instance = constructor.newInstance(paramObjects);
        return new CreatedInstance(clazz, instance);
    }

    private static Constructor<?> findConstructor(Class clazz, Class[] argTypes) throws NoSuchMethodException {
        List found = Arrays.stream(clazz.getConstructors()).filter(constructor -> constructor.getGenericParameterTypes().length == argTypes.length).filter(constructor -> {
            ArrayList<Boolean> matchedParams = new ArrayList<Boolean>();
            Type[] pts = constructor.getGenericParameterTypes();
            for (int i = 0; i < argTypes.length; ++i) {
                Type typ = pts[i];
                if (typ instanceof ParameterizedType || typ instanceof WildcardType) {
                    matchedParams.add(true);
                    continue;
                }
                if (typ instanceof GenericArrayType) {
                    matchedParams.add(argTypes[i].isArray());
                    continue;
                }
                if (typ instanceof Class) {
                    matchedParams.add(((Class)typ).isAssignableFrom(argTypes[i]));
                    continue;
                }
                matchedParams.add(true);
            }
            return matchedParams.stream().allMatch(Boolean::booleanValue);
        }).collect(Collectors.toList());
        if (!found.isEmpty()) {
            return (Constructor)found.get(0);
        }
        Class superclass = clazz.getSuperclass();
        if (superclass == null) {
            throw new NoSuchMethodException("Constructor was not found in " + clazz.getName() + " or its ancestors.");
        }
        return NativeInstantiationImpl.findConstructor(superclass, argTypes);
    }

    static CreatedInstance createCollection(String className, GeneratedArg[] params, J4rsCollectionType collectionType) throws Exception {
        boolean isJ4rsArray = className.equals("org.astonbitecode.j4rs.api.dtos.Array");
        Class<?> clazz = isJ4rsArray ? Utils.forNameBasedOnArgs(params) : Utils.forNameEnhanced(className);
        List<Object> arrayObj = Array.newInstance(clazz, params.length);
        Class[] paramTypes = (Class[])Arrays.stream(params).map(param -> param.getClazz()).toArray(Class[]::new);
        if (!isJ4rsArray && !Arrays.stream(paramTypes).allMatch(type -> type.getName().equals(className))) {
            throw new IllegalArgumentException("Could not create Java array. All the arguments should be of class " + className);
        }
        A[] paramObjects = Arrays.stream(params).map(param -> param.getObject()).toArray(Object[]::new);
        for (int i = 0; i < params.length; ++i) {
            Array.set(arrayObj, i, paramObjects[i]);
        }
        switch (collectionType) {
            case Array: {
                return new CreatedInstance(arrayObj.getClass(), arrayObj);
            }
            case List: {
                List<Object> l = clazz.isPrimitive() ? arrayObj : Arrays.asList((Object[])arrayObj);
                return new CreatedInstance(l.getClass(), l);
            }
        }
        return new CreatedInstance(arrayObj.getClass(), arrayObj);
    }

    static CreatedInstance createMap(String keyClassName, String valueClassName, GeneratedArg[] params) throws Exception {
        Class<?> keyClazz = Utils.forNameEnhanced(keyClassName);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < params.length; i += 2) {
            map.put(params[i].getObject(), params[i + 1].getObject());
        }
        return new CreatedInstance(map.getClass(), map);
    }

    static enum J4rsCollectionType {
        Array,
        List;

    }

    static class CreatedInstance {
        private Class clazz;
        private Object object;

        public CreatedInstance(Class clazz, Object object) {
            this.clazz = clazz;
            this.object = object;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

