/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.invocation;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import org.astonbitecode.j4rs.api.Instance;
import org.astonbitecode.j4rs.api.dtos.InvocationArg;
import org.astonbitecode.j4rs.api.invocation.JsonInvocationImpl;
import org.astonbitecode.j4rs.errors.InvocationException;

public class JavaFxInvocation<T>
implements Instance<T> {
    private JsonInvocationImpl<T> jsonInvocation;

    public JavaFxInvocation(JsonInvocationImpl<T> jsonInvocation) {
        this.jsonInvocation = jsonInvocation;
    }

    @Override
    public Instance invoke(String methodName, InvocationArg ... args) {
        CompletableFuture f = new CompletableFuture();
        Platform.runLater(() -> {
            Instance i = this.jsonInvocation.invoke(methodName, args);
            f.complete(i);
        });
        try {
            return (Instance)f.get();
        }
        catch (InterruptedException | ExecutionException error) {
            throw new InvocationException("While invoking method " + methodName + " of Class " + this.jsonInvocation.getObjectClass().getName(), error);
        }
    }

    @Override
    public Instance invokeStatic(String methodName, InvocationArg ... args) {
        CompletableFuture f = new CompletableFuture();
        Platform.runLater(() -> {
            Instance i = this.jsonInvocation.invokeStatic(methodName, args);
            f.complete(i);
        });
        try {
            return (Instance)f.get();
        }
        catch (InterruptedException | ExecutionException error) {
            throw new InvocationException("While invoking method " + methodName + " of Class " + this.jsonInvocation.getObjectClass().getName(), error);
        }
    }

    @Override
    public void invokeAsyncToChannel(long channelAddress, String methodName, InvocationArg ... args) {
        Platform.runLater(() -> this.jsonInvocation.invokeAsyncToChannel(channelAddress, methodName, args));
    }

    @Override
    public void invokeToChannel(long channelAddress, String methodName, InvocationArg ... args) {
        System.out.println("Invoking to channel " + methodName + " with " + args.length + " args");
        Platform.runLater(() -> this.jsonInvocation.invokeToChannel(channelAddress, methodName, args));
    }

    @Override
    public void initializeCallbackChannel(long channelAddress) {
        this.jsonInvocation.initializeCallbackChannel(channelAddress);
    }

    @Override
    public Instance<?> field(String fieldName) {
        return this.jsonInvocation.field(fieldName);
    }

    @Override
    public String getJson() {
        return this.jsonInvocation.getJson();
    }

    @Override
    public Object getObject() {
        return this.jsonInvocation.getObject();
    }

    @Override
    public Class<?> getObjectClass() {
        return this.jsonInvocation.getObjectClass();
    }

    @Override
    public String getObjectClassName() {
        return this.jsonInvocation.getObjectClassName();
    }
}

