/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.invocation;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.astonbitecode.j4rs.api.Instance;
import org.astonbitecode.j4rs.api.JsonValue;
import org.astonbitecode.j4rs.api.async.J4rsPolledFuture;
import org.astonbitecode.j4rs.api.dtos.GeneratedArg;
import org.astonbitecode.j4rs.api.dtos.InvocationArg;
import org.astonbitecode.j4rs.api.dtos.InvocationArgGenerator;
import org.astonbitecode.j4rs.api.invocation.InstanceGenerator;
import org.astonbitecode.j4rs.api.invocation.NativeCallbackToRustChannelSupport;
import org.astonbitecode.j4rs.api.invocation.NativeCallbackToRustFutureSupport;
import org.astonbitecode.j4rs.api.value.JsonValueFactory;
import org.astonbitecode.j4rs.errors.InvocationException;
import org.astonbitecode.j4rs.rust.RustPointer;

public class JsonInvocationImpl<T>
implements Instance<T> {
    private T object;
    private Class<T> clazz;
    private List<Type> classGenTypes = new ArrayList<Type>();
    private InvocationArgGenerator gen = new InvocationArgGenerator();

    public JsonInvocationImpl(Class<T> clazz) {
        this.object = null;
        this.clazz = clazz;
    }

    public JsonInvocationImpl(T instance, Class<T> clazz) {
        this.object = instance;
        this.clazz = clazz;
    }

    public JsonInvocationImpl(T instance, Class<T> clazz, List<Type> classGenTypes) {
        this.object = instance;
        this.clazz = clazz;
        this.classGenTypes = classGenTypes;
    }

    @Override
    public Instance invoke(String methodName, InvocationArg ... args) {
        try {
            CreatedInstance createdInstance = this.invokeMethod(methodName, this.gen.generateArgObjects(args));
            return InstanceGenerator.create(createdInstance.object, createdInstance.clazz, createdInstance.classGenTypes);
        }
        catch (Exception error) {
            throw new InvocationException("While invoking method " + methodName + " of Class " + this.clazz.getName(), error);
        }
    }

    @Override
    public Instance invokeStatic(String methodName, InvocationArg ... args) {
        try {
            CreatedInstance createdInstance = this.invokeMethod(methodName, this.gen.generateArgObjects(args));
            return InstanceGenerator.create(createdInstance.object, createdInstance.clazz, createdInstance.classGenTypes);
        }
        catch (Exception error) {
            throw new InvocationException("Error while invoking method " + methodName + " of Class " + this.clazz.getName(), error);
        }
    }

    @Override
    public void invokeAsyncToChannel(long channelAddress, String methodName, InvocationArg ... args) {
        try {
            NativeCallbackToRustFutureSupport callback = this.newCallbackForAsyncToChannel(channelAddress);
            this.invokeAsyncMethod(methodName, this.gen.generateArgObjects(args)).handle((o, t) -> {
                if (t != null) {
                    callback.doCallbackFailure((Throwable)t);
                } else {
                    callback.doCallbackSuccess(o);
                }
                return Void.TYPE;
            });
        }
        catch (Exception error) {
            throw new InvocationException("While invoking async method " + methodName + " of Class " + this.getObjectClassName(), error);
        }
    }

    NativeCallbackToRustFutureSupport newCallbackForAsyncToChannel(long channelAddress) {
        NativeCallbackToRustFutureSupport callback = new NativeCallbackToRustFutureSupport();
        callback.initPointer(new RustPointer(channelAddress));
        return callback;
    }

    @Override
    public void invokeToChannel(long channelAddress, String methodName, InvocationArg ... args) {
        this.initializeCallbackChannel(channelAddress);
        this.invoke(methodName, args);
    }

    @Override
    public void initializeCallbackChannel(long channelAddress) {
        if (!NativeCallbackToRustChannelSupport.class.isAssignableFrom(this.clazz)) {
            throw new InvocationException("Cannot initialize callback channel for class " + this.clazz.getName() + ". The class does not extend the class " + NativeCallbackToRustChannelSupport.class.getName());
        }
        ((NativeCallbackToRustChannelSupport)this.object).initPointer(new RustPointer(channelAddress));
    }

    @Override
    public Instance field(String fieldName) {
        try {
            CreatedInstance createdInstance = this.getField(fieldName);
            return new JsonInvocationImpl<Object>(createdInstance.object, createdInstance.clazz);
        }
        catch (Exception error) {
            throw new InvocationException("Error while accessing field " + fieldName + " of Class " + this.clazz.getName(), error);
        }
    }

    public T getObject() {
        return this.object;
    }

    public Class<T> getObjectClass() {
        return this.clazz;
    }

    @Override
    public String getObjectClassName() {
        return this.clazz != null ? this.clazz.getName() : "null";
    }

    @Override
    public String getJson() {
        JsonValue jsonValue = JsonValueFactory.create(this.object);
        return jsonValue.getJson();
    }

    CreatedInstance getField(String fieldName) throws Exception {
        Field field = this.clazz.getField(fieldName);
        Object fieldObject = field.get(this.object);
        return new CreatedInstance(field.getType(), fieldObject);
    }

    CreatedInstance invokeMethod(String methodName, GeneratedArg[] generatedArgs) throws Exception {
        Class[] argTypes = (Class[])Arrays.stream(generatedArgs).map(invGeneratedArg -> {
            try {
                return invGeneratedArg.getClazz();
            }
            catch (Exception error) {
                throw new InvocationException("Cannot parse the parameter types while invoking method", error);
            }
        }).toArray(Class[]::new);
        Object[] argObjects = Arrays.stream(generatedArgs).map(invGeneratedArg -> {
            try {
                return invGeneratedArg.getObject();
            }
            catch (Exception error) {
                throw new InvocationException("Cannot parse the parameter objects while invoking method", error);
            }
        }).toArray(Object[]::new);
        Method methodToInvoke = this.findMethodInHierarchy(this.clazz, methodName, argTypes);
        ArrayList<Type> retClassGenTypes = new ArrayList();
        Type returnType = methodToInvoke.getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)returnType;
            retClassGenTypes = Arrays.asList(type.getActualTypeArguments());
        }
        Class<?> invokedMethodReturnType = methodToInvoke.getReturnType();
        Object returnedObject = methodToInvoke.invoke(this.object, argObjects);
        return new CreatedInstance(invokedMethodReturnType, returnedObject, retClassGenTypes);
    }

    CompletableFuture<Object> invokeAsyncMethod(String methodName, GeneratedArg[] generatedArgs) throws Exception {
        Class<?> invokedMethodReturnType;
        Class[] argTypes = (Class[])Arrays.stream(generatedArgs).map(invGeneratedArg -> {
            try {
                return invGeneratedArg.getClazz();
            }
            catch (Exception error) {
                throw new InvocationException("Cannot parse the parameter types while invoking async method", error);
            }
        }).toArray(Class[]::new);
        Object[] argObjects = Arrays.stream(generatedArgs).map(invGeneratedArg -> {
            try {
                return invGeneratedArg.getObject();
            }
            catch (Exception error) {
                throw new InvocationException("Cannot parse the parameter objects while invoking async method", error);
            }
        }).toArray(Object[]::new);
        Method methodToInvoke = this.findMethodInHierarchy(this.clazz, methodName, argTypes);
        List<Object> retClassGenTypes = new ArrayList();
        Type returnType = methodToInvoke.getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)returnType;
            retClassGenTypes = Arrays.asList(type.getActualTypeArguments());
        }
        if (!Future.class.isAssignableFrom(invokedMethodReturnType = methodToInvoke.getReturnType())) {
            String message = String.format("Attempted to asynchronously invoke method %s of class %s that returns %s instead of returning Future", methodName, this.clazz.getName(), returnType.getTypeName());
            throw new InvocationException(message);
        }
        Future invocationReturnedFuture = (Future)methodToInvoke.invoke(this.object, argObjects);
        J4rsPolledFuture<Object> future = invocationReturnedFuture instanceof CompletableFuture ? (J4rsPolledFuture<Object>)invocationReturnedFuture : new J4rsPolledFuture<Object>(invocationReturnedFuture);
        return future;
    }

    Method findMethodInHierarchy(Class clazz, String methodName, Class[] argTypes) throws NoSuchMethodException {
        HashSet<Method> methods = new HashSet<Method>(Arrays.asList(clazz.getDeclaredMethods()));
        Set interfacesMethods = Arrays.stream(clazz.getInterfaces()).map(c -> c.getDeclaredMethods()).flatMap(m -> Arrays.stream(m)).collect(Collectors.toSet());
        methods.addAll(interfacesMethods);
        List found = methods.stream().filter(m -> m.getName().equals(methodName)).filter(m -> m.getGenericParameterTypes().length == argTypes.length).filter(m -> {
            ArrayList<Boolean> matchedParams = new ArrayList<Boolean>();
            Type[] pts = m.getGenericParameterTypes();
            for (int i = 0; i < argTypes.length; ++i) {
                Type typ = pts[i];
                if (typ instanceof ParameterizedType || typ instanceof WildcardType) {
                    matchedParams.add(true);
                    continue;
                }
                if (typ instanceof GenericArrayType) {
                    matchedParams.add(argTypes[i].isArray());
                    continue;
                }
                if (typ instanceof Class) {
                    matchedParams.add(((Class)typ).isAssignableFrom(argTypes[i]));
                    continue;
                }
                matchedParams.add(true);
            }
            return matchedParams.stream().allMatch(Boolean::booleanValue);
        }).collect(Collectors.toList());
        if (!found.isEmpty()) {
            return (Method)found.get(0);
        }
        Class superclass = clazz.getSuperclass();
        if (superclass == null) {
            throw new NoSuchMethodException("Method " + methodName + " was not found in " + this.clazz.getName() + " or its ancestors.");
        }
        return this.findMethodInHierarchy(superclass, methodName, argTypes);
    }

    private boolean validateSomeTypeSafety(Class c) {
        List filteredTypeList = this.classGenTypes.stream().filter(cgt -> ((Class)cgt).isAssignableFrom(c)).collect(Collectors.toList());
        return this.classGenTypes.isEmpty() || filteredTypeList.isEmpty();
    }

    class CreatedInstance {
        private Class clazz;
        private Object object;
        private List<Type> classGenTypes;

        public CreatedInstance(Class clazz, Object object) {
            this.clazz = clazz;
            this.object = object;
        }

        public CreatedInstance(Class clazz, Object object, List<Type> classGenTypes) {
            this.clazz = clazz;
            this.object = object;
            this.classGenTypes = classGenTypes;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

