/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.invocation;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import org.astonbitecode.j4rs.api.Instance;
import org.astonbitecode.j4rs.api.invocation.InstanceGenerator;
import org.astonbitecode.j4rs.api.value.NullObject;
import org.astonbitecode.j4rs.errors.InvocationException;
import org.astonbitecode.j4rs.rust.RustPointer;

class NativeCallbackToRustFutureSupport {
    private Optional<RustPointer> channelPointerOpt = Optional.empty();

    NativeCallbackToRustFutureSupport() {
    }

    private static native int docallbacktochannel(long var0, Instance var2);

    private static native int failcallbacktochannel(long var0, String var2);

    static void initialize(String libname) {
        try {
            System.loadLibrary(libname);
        }
        catch (UnsatisfiedLinkError error) {
            System.err.println("The Callbacks are not initialized because the j4rs lib was not found. You may ignore this error if you don't use callbacks.");
            error.printStackTrace();
        }
    }

    public void doCallbackSuccess(Object obj) {
        if (this.channelPointerOpt.isPresent()) {
            if (obj != null) {
                NativeCallbackToRustFutureSupport.docallbacktochannel(this.channelPointerOpt.get().getAddress(), InstanceGenerator.create(obj, obj.getClass()));
            } else {
                NativeCallbackToRustFutureSupport.docallbacktochannel(this.channelPointerOpt.get().getAddress(), InstanceGenerator.create(null, NullObject.class));
            }
        } else {
            throw new InvocationException("Cannot do callback. Please make sure that you don't try to access this method while being in the constructor of your class (that extends NativeCallbackToRustFutureSupport)");
        }
    }

    public void doCallbackFailure(Throwable error) {
        if (!this.channelPointerOpt.isPresent() || error == null) {
            throw new InvocationException("Cannot do callback for failure. Please make sure that you don't try to access this method while being in the constructor of your class (that extends NativeCallbackSupport). The failure was: ", error);
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        error.printStackTrace(pw);
        String stringStackTrace = sw.toString();
        NativeCallbackToRustFutureSupport.failcallbacktochannel(this.channelPointerOpt.get().getAddress(), stringStackTrace);
    }

    final void initPointer(RustPointer p) {
        this.channelPointerOpt = Optional.of(p);
    }
}

