/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.jfx;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.astonbitecode.j4rs.api.jfx.controllers.FxController;
import org.astonbitecode.j4rs.api.jfx.controllers.FxControllerImpl;
import org.astonbitecode.j4rs.api.jfx.errors.FxException;

public class J4rsFxmlLoader {
    public static FxController loadFxml(Stage stage, String fxmlPath) throws IOException, FxException {
        FXMLLoader loader = new FXMLLoader();
        URL resurl = new File(fxmlPath).toURI().toURL();
        loader.setControllerFactory(clazz -> new FxControllerImpl());
        loader.setLocation(resurl);
        Parent root = (Parent)loader.load();
        Scene scene = new Scene(root);
        stage.setScene(scene);
        FxController controller = (FxController)loader.getController();
        if (controller == null) {
            throw new FxException(String.format("Could not load the fxml %s. Please make sure that its root element contains fx:controller=\"org.astonbitecode.j4rs.api.jfx.controllers.FxController\"", fxmlPath));
        }
        controller.setScene(scene);
        return controller;
    }
}

