/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.jfx.controllers;

import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.Scene;
import org.astonbitecode.j4rs.api.invocation.NativeCallbackToRustChannelSupport;
import org.astonbitecode.j4rs.api.jfx.controllers.FxController;
import org.astonbitecode.j4rs.api.jfx.errors.ComponentNotFoundException;

public class FxControllerImpl
implements FxController {
    private Scene scene;
    private AtomicReference<NativeCallbackToRustChannelSupport> initializeCb = new AtomicReference<Object>(null);
    private AtomicBoolean controllerLoaded = new AtomicBoolean(false);

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.controllerLoaded.getAndSet(true);
        if (this.initializeCb.get() != null) {
            this.initializeCb.get().doCallback(new Object());
        }
    }

    @Override
    public void addControllerInitializedCallback(NativeCallbackToRustChannelSupport callback) {
        this.initializeCb.getAndSet(callback);
        if (this.controllerLoaded.get()) {
            callback.doCallback(new Object());
        }
    }

    @Override
    public void addEventHandler(String id, EventHandler<Event> handler, EventType<?> eventType) throws ComponentNotFoundException {
        Node node = this.getNodeById(id);
        node.addEventHandler(eventType, handler);
    }

    @Override
    public Node getNodeById(String id) throws ComponentNotFoundException {
        Node node;
        if (this.scene != null && (node = this.scene.lookup("#" + id)) != null) {
            return node;
        }
        throw new ComponentNotFoundException(String.format("Node with id %s was not found.", id));
    }

    @Override
    public void setScene(Scene scene) {
        this.scene = scene;
    }
}

