/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.value;

import org.astonbitecode.j4rs.api.JsonValue;
import org.astonbitecode.j4rs.api.services.json.Codec;
import org.astonbitecode.j4rs.api.services.json.exceptions.JsonCodecException;
import org.astonbitecode.j4rs.json.JsonCodecService;

public class JsonValueImpl
implements JsonValue {
    private final Codec jsonCodec = JsonCodecService.getJsonCodec();
    private Object obj;
    private String json;
    private String className;

    <T> JsonValueImpl(T obj) {
        this.obj = obj;
        try {
            this.json = this.jsonCodec.encode(obj);
        }
        catch (JsonCodecException error) {
            throw new JsonCodecException("While creating JsonValueCallbackImpl for instance of " + obj.getClass().getName(), error);
        }
        this.className = obj.getClass().getName();
    }

    JsonValueImpl(String json, String className) {
        try {
            this.obj = className.equals("org.astonbitecode.j4rs.api.dtos.Array") ? this.jsonCodec.decodeArrayContents(json) : this.jsonCodec.decode(json, className);
        }
        catch (JsonCodecException error) {
            throw new JsonCodecException("While creating JsonValueCallbackImpl: Could not decode " + json, error);
        }
        this.json = json;
        this.className = className;
    }

    @Override
    public String getJson() {
        return this.json;
    }

    @Override
    public Object getObject() {
        return this.obj;
    }

    @Override
    public Class<?> getObjectClass() {
        return this.obj.getClass();
    }

    @Override
    public String getObjectClassName() {
        return this.obj.getClass().getName();
    }
}

