/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.astonbitecode.j4rs.api.services.json.Codec;
import org.astonbitecode.j4rs.api.services.json.exceptions.JsonCodecException;
import org.astonbitecode.j4rs.utils.Utils;

public class JacksonCodec
implements Codec {
    private static final String RUST_FIELD = "Rust";
    private static final String JSON_FIELD = "json";
    private static final String CLASS_NAME_FIELD = "class_name";
    private ObjectMapper mapper = new ObjectMapper();
    TypeReference<Map<String, Object>[]> typeRef = new TypeReference<Map<String, Object>[]>(){};

    @Override
    public <T> T decode(String json, String className) throws JsonCodecException {
        try {
            Class<?> clazz = null;
            clazz = Utils.forNameEnhanced(className);
            Object obj = this.mapper.readValue(json, clazz);
            return (T)obj;
        }
        catch (JsonProcessingException | ClassNotFoundException error) {
            throw new JsonCodecException((Exception)error);
        }
    }

    public String encode(Object obj) throws JsonCodecException {
        try {
            return this.mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException error) {
            throw new JsonCodecException((Exception)((Object)error));
        }
    }

    @Override
    public Object[] decodeArrayContents(String json) throws JsonCodecException {
        try {
            Map[] array = (Map[])this.mapper.readValue(json, this.typeRef);
            return Arrays.stream(array).map(elem -> {
                try {
                    return this.retrieveFromMap((Map<String, Object>)elem);
                }
                catch (Exception error) {
                    throw new JsonCodecException("Error while retrieving Array", error);
                }
            }).toArray();
        }
        catch (JsonProcessingException error) {
            throw new JsonCodecException((Exception)((Object)error));
        }
    }

    private <U> U retrieveFromMap(Map<String, Object> map) throws ClassNotFoundException, IOException {
        Map innerMap = (Map)map.get(RUST_FIELD);
        if (innerMap == null) {
            throw new JsonCodecException("Cannot create InvocationArg object form Map '" + map + "'");
        }
        String retrievedClassName = (String)innerMap.get(CLASS_NAME_FIELD);
        String retrievedJson = (String)innerMap.get(JSON_FIELD);
        if (retrievedClassName == null || retrievedJson == null) {
            throw new JsonCodecException("Cannot create InvocationArg object form the JSON '" + retrievedJson + "'");
        }
        return (U)this.decode(retrievedJson, retrievedClassName);
    }
}

