/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.astonbitecode.j4rs.errors.InvocationException;
import org.astonbitecode.j4rs.tests.DummyMapImpl;
import org.astonbitecode.j4rs.tests.DummyMapInterface;
import org.astonbitecode.j4rs.tests.MyBean;

public class MyTest {
    private String string;
    public static String StaticString = "This is a static String from Java";
    private static ExecutorService executor = Executors.newSingleThreadExecutor();

    public MyTest() {
        this.string = "THE DEFAULT CONSTRUCTOR WAS CALLED";
    }

    public MyTest(MyTest myTest) {
        this.string = myTest.string;
    }

    public MyTest(String str) {
        this.string = str;
    }

    public MyTest(String ... args) {
        this.string = Arrays.stream(args).collect(Collectors.joining(", "));
    }

    public static void useLongPrimitivesArray(long[] args) {
    }

    public String getMyString() {
        return this.string;
    }

    public String appendToMyString(String str) {
        this.string = this.string + str;
        return this.string;
    }

    public String getMyWithArgs(String arg) {
        return this.string + arg;
    }

    public String getMyWithArgsList(String ... args) {
        String str = Arrays.stream(args).reduce("", (a, b) -> a + b);
        return str;
    }

    public List<Integer> getNumbersUntil(Integer until) {
        if (until == null) {
            return new ArrayList<Integer>();
        }
        return IntStream.range(0, until).boxed().collect(Collectors.toList());
    }

    public Integer addInts(Integer ... args) {
        int result = Arrays.stream(args).reduce(0, (a, b) -> a + b);
        return result;
    }

    public Integer addInts(int a, int b) {
        return a + b;
    }

    public void list(List<String> l) {
        String str = l.stream().reduce("The arguments passed where", (a, b) -> a + "\n" + b);
    }

    public void map(Map<String, Integer> m) {
        m.entrySet().stream().map((? super T entry) -> ((String)entry.getKey()).getClass().isAssignableFrom(String.class) && ((Integer)entry.getValue()).getClass().isAssignableFrom(Integer.class)).collect(Collectors.toList());
    }

    public void aMethod() {
        System.out.println("A METHOD CALLED");
    }

    public static void StaticMethod() {
        System.out.println("Static");
    }

    public <T> T echo(T o) {
        return o;
    }

    public DummyMapInterface<String, Object> getMap() {
        return new DummyMapImpl();
    }

    public Integer getNullInteger() {
        return null;
    }

    public String getTheString(MyBean myBean) {
        return myBean.getSomeString();
    }

    public Integer getTheInteger(MyBean myBean) {
        return myBean.getSomeInteger();
    }

    public Future<String> getStringWithFuture(String string) {
        return executor.submit(() -> string);
    }

    public Future<String> getErrorWithFuture(String message) {
        return executor.submit(() -> {
            throw new InvocationException(message);
        });
    }

    public Future<Void> executeVoidFuture(String message) {
        return executor.submit(() -> null);
    }

    public static Future<String> getErrorWithFutureStatic(String string) {
        return executor.submit(() -> string);
    }
}

