/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api;

import org.astonbitecode.j4rs.api.JsonValue;
import org.astonbitecode.j4rs.api.ObjectValue;
import org.astonbitecode.j4rs.api.dtos.InvocationArg;
import org.astonbitecode.j4rs.api.invocation.JsonInvocationImpl;
import org.astonbitecode.j4rs.api.value.JsonValueFactory;
import org.astonbitecode.j4rs.errors.InvocationException;
import org.astonbitecode.j4rs.utils.Utils;

public interface Instance<T>
extends ObjectValue,
JsonValue {
    public Instance invoke(String var1, InvocationArg ... var2);

    public Instance invokeStatic(String var1, InvocationArg ... var2);

    public void invokeAsyncToChannel(long var1, String var3, InvocationArg ... var4);

    public void invokeToChannel(long var1, String var3, InvocationArg ... var4);

    public void initializeCallbackChannel(long var1);

    public Instance field(String var1);

    public static <T> Instance cast(Instance from, String toClass) {
        try {
            Class<?> clazz = Utils.forNameEnhanced(toClass);
            return new JsonInvocationImpl(clazz.cast(from.getObject()), clazz);
        }
        catch (Exception error) {
            throw new InvocationException("Cannot cast instance of " + from.getObject().getClass().getName() + " to " + toClass, error);
        }
    }

    public static <T> Instance cloneInstance(Instance from) {
        return new JsonInvocationImpl<Object>(from.getObject(), from.getObjectClass());
    }

    default public T getOrDeserializeJavaObject() {
        boolean isSerialized = false;
        if (InvocationArg.class.isAssignableFrom(this.getClass())) {
            isSerialized = ((InvocationArg)this).isSerialized();
        }
        if (!isSerialized) {
            return (T)this.getObject();
        }
        JsonValue objValue = JsonValueFactory.create(this.getJson(), this.getObjectClassName());
        return (T)objValue.getObject();
    }

    default public <U> boolean checkEquals(Instance<U> other) {
        T a = this.getOrDeserializeJavaObject();
        U b = other.getOrDeserializeJavaObject();
        if (a != null && b != null) {
            return a.equals(b);
        }
        return a == null && b == null;
    }
}

