/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.async;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.astonbitecode.j4rs.api.async.J4rsAsyncContext;

public class J4rsPolledFuture<T>
extends CompletableFuture<T> {
    private final Future<T> future;

    public J4rsPolledFuture(Future<T> future) {
        this.future = future;
        J4rsAsyncContext.schedule(this::tryToComplete);
    }

    private void tryToComplete() {
        if (this.future.isDone()) {
            try {
                this.complete(this.future.get());
            }
            catch (InterruptedException error) {
                this.completeExceptionally(error);
            }
            catch (ExecutionException error) {
                this.completeExceptionally(error.getCause());
            }
            return;
        }
        if (this.future.isCancelled()) {
            this.cancel(true);
            return;
        }
        J4rsAsyncContext.schedule(this::tryToComplete);
    }
}

