/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.deploy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.astonbitecode.j4rs.api.deploy.DeployUtils;

public class FileSystemDeployer {
    private final String deployTarget;

    public FileSystemDeployer() {
        this(".");
    }

    public FileSystemDeployer(String deployTarget) {
        this.deployTarget = deployTarget;
        new File(deployTarget).mkdirs();
    }

    public void deploy(String path) throws IOException {
        File jarFile = new File(path);
        ReadableByteChannel readableByteChannel = Channels.newChannel(jarFile.toURI().toURL().openStream());
        String fullJarDeployPath = this.deployTarget + File.separator + jarFile.getName();
        try (FileOutputStream fileOutputStream = new FileOutputStream(fullJarDeployPath);){
            fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        }
        DeployUtils.addToClasspath(fullJarDeployPath);
    }
}

