/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.deploy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.astonbitecode.j4rs.api.deploy.DeployUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SimpleMavenDeployer {
    private static final String MAVEN_CENTRAL = "https://repo.maven.apache.org/maven2";
    private final String M2_CACHE = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository";
    private final String repoBase;
    private final boolean checkLocalCache;
    private final String deployTarget;

    public SimpleMavenDeployer() {
        this(MAVEN_CENTRAL, true, ".");
    }

    public SimpleMavenDeployer(String deployTarget) {
        this(MAVEN_CENTRAL, true, deployTarget);
    }

    public SimpleMavenDeployer(String repoBase, String deployTarget) {
        this(repoBase, true, deployTarget);
    }

    public SimpleMavenDeployer(String repoBase, boolean checkLocalCache, String deployTarget) {
        this.repoBase = repoBase;
        this.checkLocalCache = checkLocalCache;
        this.deployTarget = deployTarget;
        new File(deployTarget).mkdirs();
    }

    public void deploy(String groupId, String artifactId, String version, String qualifier) throws IOException {
        String jarName = this.generateArtifactName(artifactId, version, qualifier);
        boolean searchRemoteRepo = true;
        if (!this.artifactExists(groupId, artifactId, version, qualifier)) {
            String fullJarDeployPath = this.deployTarget + File.separator + jarName;
            if (this.checkLocalCache) {
                try {
                    this.deployFromLocalCache(groupId, artifactId, version, qualifier);
                    searchRemoteRepo = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (searchRemoteRepo) {
                String urlString = this.generateUrlTagret(groupId, artifactId, version, jarName);
                ReadableByteChannel readableByteChannel = Channels.newChannel(new URL(urlString).openStream());
                try (FileOutputStream fileOutputStream = new FileOutputStream(fullJarDeployPath);){
                    fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                }
            }
            DeployUtils.addToClasspath(fullJarDeployPath);
        }
    }

    private boolean artifactExists(String groupId, String artifactId, String version, String qualifier) {
        String jarName = this.generateArtifactName(artifactId, version, qualifier);
        String pathString = this.deployTarget + File.separator + jarName;
        return new File(pathString).exists();
    }

    void deployFromLocalCache(String groupId, String artifactId, String version, String qualifier) throws MalformedURLException, IOException {
        String jarName = this.generateArtifactName(artifactId, version, qualifier);
        String pathString = this.generatePathTagret(this.M2_CACHE, groupId, artifactId, version, jarName);
        ReadableByteChannel readableByteChannel = Channels.newChannel(new File(pathString).toURI().toURL().openStream());
        FileOutputStream fileOutputStream = new FileOutputStream(this.deployTarget + File.separator + jarName);
        fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
    }

    String generateArtifactName(String artifactId, String version, String qualifier) {
        StringBuilder jarName = new StringBuilder(String.format("%s-%s", artifactId, version));
        if (qualifier != null && !qualifier.isEmpty()) {
            jarName.append("-").append(qualifier);
        }
        jarName.append(".jar");
        return jarName.toString();
    }

    String generateUrlTagret(String groupId, String artifactId, String version, String jarName) throws IOException {
        if (version.endsWith("-SNAPSHOT")) {
            String latestSnapshotJarName = this.getLatestSnapshotName(groupId, artifactId, version);
            return String.format("%s/%s/%s/%s/%s", this.repoBase, groupId.replace(".", "/"), artifactId, version, latestSnapshotJarName);
        }
        return String.format("%s/%s/%s/%s/%s", this.repoBase, groupId.replace(".", "/"), artifactId, version, jarName);
    }

    private String getLatestSnapshotName(String groupId, String artifactId, String version) throws IOException {
        String string;
        block8: {
            String metadataXmlUrl = String.format("%s/%s/%s/%s/%s", this.repoBase, groupId.replace(".", "/"), artifactId, version, "maven-metadata.xml");
            ReadableByteChannel readableByteChannel = Channels.newChannel(new URL(metadataXmlUrl).openStream());
            InputStream inputStream = Channels.newInputStream(readableByteChannel);
            try {
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document xmlDocument = builder.parse(inputStream);
                XPath xPath = XPathFactory.newInstance().newXPath();
                String timestamp = xPath.evaluate("/metadata/versioning/snapshot/timestamp", xmlDocument);
                String buildNumber = xPath.evaluate("/metadata/versioning/snapshot/buildNumber", xmlDocument);
                String snapshotVersion = version.replace("SNAPSHOT", timestamp + "-" + buildNumber);
                string = String.format("%s-%s.jar", artifactId, snapshotVersion);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParserConfigurationException | XPathExpressionException | SAXException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    String generatePathTagret(String base, String groupId, String artifactId, String version, String jarName) {
        return String.format("%s%s%s%s%s%s%s%s%s", base, File.separator, groupId.replace(".", File.separator), File.separator, artifactId, File.separator, version, File.separator, jarName);
    }

    public String getRepoBase() {
        return this.repoBase;
    }
}

