/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.dtos;

import java.util.Arrays;
import org.astonbitecode.j4rs.api.Instance;
import org.astonbitecode.j4rs.api.JsonValue;
import org.astonbitecode.j4rs.api.dtos.GeneratedArg;
import org.astonbitecode.j4rs.api.dtos.InvocationArg;
import org.astonbitecode.j4rs.api.value.JsonValueFactory;
import org.astonbitecode.j4rs.errors.InvalidArgumentException;
import org.astonbitecode.j4rs.utils.Utils;

public class InvocationArgGenerator {
    public GeneratedArg[] generateArgObjects(InvocationArg[] args) {
        GeneratedArg[] generatedArgArr = (GeneratedArg[])Arrays.stream(args).map(invArg -> {
            GeneratedArg generatedArg;
            if (invArg.isSerialized()) {
                JsonValue objValue = JsonValueFactory.create(invArg.getJson(), invArg.getObjectClassName());
                try {
                    generatedArg = invArg.getObjectClassName().equals("org.astonbitecode.j4rs.api.dtos.Array") ? new GeneratedArg(objValue.getObjectClass(), objValue.getObject()) : new GeneratedArg(Utils.forNameEnhanced(invArg.getObjectClassName()), objValue.getObject());
                }
                catch (ClassNotFoundException cnfe) {
                    throw new InvalidArgumentException("Cannot parse InvocationArgument ", cnfe);
                }
            }
            Instance inv = invArg.getInstance();
            try {
                generatedArg = new GeneratedArg(inv != null ? inv.getObjectClass() : Utils.forNameEnhanced(invArg.getObjectClassName()), inv != null ? inv.getObject() : null);
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println("j4rs Warning! ClassNotFoundException for " + invArg.getObjectClassName() + " Using java.lang.Object instead...");
                generatedArg = new GeneratedArg(Object.class, null);
            }
            return generatedArg;
        }).toArray(GeneratedArg[]::new);
        return generatedArgArr;
    }

    public static GeneratedArg argOf(Class clazz, Object object) {
        return new GeneratedArg(clazz, object);
    }
}

