/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.invocation;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.astonbitecode.j4rs.api.Instance;
import org.astonbitecode.j4rs.api.invocation.JsonInvocationImpl;
import org.astonbitecode.j4rs.api.services.delegates.InstanceGeneratorDelegate;
import org.astonbitecode.j4rs.errors.InvocationException;

public class InstanceGenerator {
    private static Map<String, InstanceGeneratorDelegate> delegates = new HashMap<String, InstanceGeneratorDelegate>();

    public static <T> Instance<T> create(T instance, Class<T> clazz, List<Type> classGenTypes) {
        JsonInvocationImpl<T> jsonInvocation = new JsonInvocationImpl<T>(instance, clazz, classGenTypes);
        if (InstanceGenerator.shouldRunInFxThread(jsonInvocation.getObjectClass())) {
            return InstanceGenerator.getProxiedForJavaFx(jsonInvocation);
        }
        return jsonInvocation;
    }

    public static <T> Instance<T> create(T instance, Class clazz) {
        JsonInvocationImpl<T> jsonInvocation = new JsonInvocationImpl<T>(instance, clazz);
        if (InstanceGenerator.shouldRunInFxThread(jsonInvocation.getObjectClass())) {
            return InstanceGenerator.getProxiedForJavaFx(jsonInvocation);
        }
        return jsonInvocation;
    }

    public static <T> Instance<T> create(Class clazz) {
        JsonInvocationImpl jsonInvocation = new JsonInvocationImpl(clazz);
        if (InstanceGenerator.shouldRunInFxThread(jsonInvocation.getObjectClass())) {
            return InstanceGenerator.getProxiedForJavaFx(jsonInvocation);
        }
        return jsonInvocation;
    }

    private static <T> Instance<T> getProxiedForJavaFx(Instance<T> instance) {
        InstanceGeneratorDelegate delegate = delegates.get("org.astonbitecode.j4rs.api.invocation.JavaFxInstanceGeneratorDelegate");
        if (delegate == null) {
            throw new InvocationException("Attempted to proxy Instance in order to be executed in FX thread, but delegate is not configured. Please make sure you have j4rs-javafx in the classpath");
        }
        return delegate.proxy(instance);
    }

    private static boolean shouldRunInFxThread(Class<?> clazz) {
        String className = clazz.getName();
        return className.startsWith("javafx") || className.startsWith("org.astonbitecode.j4rs.api.jfx") && !className.startsWith("org.astonbitecode.j4rs.api.jfx.FxApplication");
    }

    static {
        ServiceLoader<InstanceGeneratorDelegate> loader = ServiceLoader.load(InstanceGeneratorDelegate.class);
        for (InstanceGeneratorDelegate d : loader) {
            delegates.put(d.getClass().getCanonicalName(), d);
        }
    }
}

