/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.invocation;

import java.util.Optional;
import org.astonbitecode.j4rs.api.Instance;
import org.astonbitecode.j4rs.api.invocation.InstanceGenerator;
import org.astonbitecode.j4rs.errors.InvocationException;
import org.astonbitecode.j4rs.rust.RustPointer;

public class NativeCallbackToRustChannelSupport {
    private Optional<RustPointer> channelPointerOpt = Optional.empty();

    private static native int docallbacktochannel(long var0, Instance var2);

    static void initialize(String libname) {
        try {
            System.loadLibrary(libname);
        }
        catch (UnsatisfiedLinkError error) {
            System.err.println("The Callbacks are not initialized because the j4rs lib was not found. You may ignore this error if you don't use callbacks.");
            error.printStackTrace();
        }
    }

    public void doCallback(Object obj) {
        if (!this.channelPointerOpt.isPresent() || obj == null) {
            throw new InvocationException("Cannot do callback. Please make sure that you don't try to access this method while being in the constructor of your class (that extends NativeCallbackSupport)");
        }
        NativeCallbackToRustChannelSupport.docallbacktochannel(this.channelPointerOpt.get().getAddress(), InstanceGenerator.create(obj, obj.getClass()));
    }

    final void initPointer(RustPointer p) {
        this.channelPointerOpt = Optional.of(p);
    }
}

