/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.astonbitecode.j4rs.api.dtos.GeneratedArg;
import org.astonbitecode.j4rs.errors.InvocationException;

public class Utils {
    private static boolean IsAndroid;

    public static Class<?> forNameEnhanced(String className) throws ClassNotFoundException {
        switch (className) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        if (!IsAndroid) {
            return Class.forName(className, true, ClassLoader.getSystemClassLoader());
        }
        return Class.forName(className);
    }

    public static Class<?> forNameBasedOnArgs(GeneratedArg[] params) {
        return Arrays.stream(params).map(arg -> arg.getClazz()).reduce((a, b) -> a).orElse(Void.class);
    }

    public static String throwableToString(Throwable throwable) {
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (throwable != null && throwable instanceof InvocationException && throwable.getCause() != null && throwable.getCause() instanceof InvocationTargetException) {
                throwable.getCause().getCause().printStackTrace(pw);
            } else {
                throwable.printStackTrace(pw);
            }
            return sw.toString();
        }
        return "Cannot create String out of a null Throwable";
    }

    static {
        try {
            Class.forName("android.os.Build");
            IsAndroid = true;
        }
        catch (ClassNotFoundException e) {
            IsAndroid = false;
        }
    }
}

