/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.kiv.md2odt;

import com.vladsch.flexmark.parser.Parser;
import cz.zcu.kiv.md2odt.Extensions;
import cz.zcu.kiv.md2odt.FlexMarkExtensions;
import cz.zcu.kiv.md2odt.document.odfdom.OdfdomDocument;
import cz.zcu.kiv.md2odt.filler.ResourceManager;
import cz.zcu.kiv.md2odt.filler.ResourceManagerImpl;
import cz.zcu.kiv.md2odt.filler.Source;
import cz.zcu.kiv.md2odt.filler.SourceCharStream;
import cz.zcu.kiv.md2odt.filler.SourceFolder;
import cz.zcu.kiv.md2odt.filler.SourceString;
import cz.zcu.kiv.md2odt.filler.SourceZip;
import cz.zcu.kiv.md2odt.filler.md.FlexMarkFiller;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class Converter {
    private static final String DEFAULT_TEMPLATE = "/default-template.odt";
    private static final Predicate<URL> DEFAULT_RESOURCE_POLICY = url -> true;
    private static final long DEFAULT_RESOURCES_LIMIT = Long.MAX_VALUE;
    private static final Pattern SOURCE_FILE_PATTERN = Pattern.compile(".*\\.md");
    private Source input;
    private InputStream template;
    private OutputStream output;
    private FlexMarkExtensions extensions = new FlexMarkExtensions();
    private long resourcesLimit = Long.MAX_VALUE;
    private Predicate<URL> resourcesPolicy;

    public Converter setInput(String md) {
        this.input = new SourceString(md);
        return this;
    }

    public Converter setInput(InputStream in, Charset charset) throws IOException {
        this.input = new SourceCharStream(in, charset);
        return this;
    }

    public Converter setInput(File file, Charset charset) throws IOException {
        return this.setInput(new FileInputStream(file), charset);
    }

    public Converter setInput(Path file, Charset charset) throws IOException {
        return this.setInput(file.toFile(), charset);
    }

    public Converter setInputZip(InputStream in, Charset charset) throws IOException {
        this.input = new SourceZip(in, charset, SOURCE_FILE_PATTERN);
        return this;
    }

    public Converter setInputZip(File file, Charset charset) throws IOException {
        return this.setInputZip(new FileInputStream(file), charset);
    }

    public Converter setInputZip(Path file, Charset charset) throws IOException {
        return this.setInputZip(file.toFile(), charset);
    }

    public Converter setInputFolder(File file, Charset charset) throws IOException {
        this.input = new SourceFolder(file, charset, SOURCE_FILE_PATTERN);
        return this;
    }

    public Converter setTemplate(InputStream template) throws IOException {
        this.template = template;
        return this;
    }

    public Converter setTemplate(File file) throws IOException {
        return this.setTemplate(new FileInputStream(file));
    }

    public Converter setTemplate(Path file) throws IOException {
        return this.setTemplate(file.toFile());
    }

    public Converter setOutput(OutputStream out) throws IOException {
        this.output = out;
        return this;
    }

    public Converter setOutput(File file) throws IOException {
        return this.setOutput(new FileOutputStream(file, false));
    }

    public Converter setOutput(Path file) throws IOException {
        return this.setOutput(file.toFile());
    }

    public Converter setResourcesLimit(long resourcesLimit) {
        this.resourcesLimit = resourcesLimit;
        return this;
    }

    public Converter setResourcesPolicy(Predicate<URL> predicate) {
        this.resourcesPolicy = predicate;
        return this;
    }

    public Converter enableExtension(String extension) {
        this.extensions.add(extension);
        return this;
    }

    public Converter enableExtensions(Collection<String> collection) {
        collection.forEach(this::enableExtension);
        return this;
    }

    public Converter enableExtensions(String ... array) {
        return this.enableExtensions(Arrays.asList(array));
    }

    public Converter enableAllExtensions() {
        return this.enableExtensions(Extensions.LIST);
    }

    public void convert() throws IOException {
        if (this.input == null) {
            throw new IllegalArgumentException("Input not set");
        }
        if (this.output == null) {
            throw new IllegalArgumentException("Output not set");
        }
        OdfdomDocument document = new OdfdomDocument(this.getTemplate());
        Parser parser = Parser.builder().extensions(this.extensions.getExtensions()).build();
        FlexMarkFiller filler = new FlexMarkFiller(parser);
        filler.fill(this.input.getSource(), this.getResourceManager(), document);
        document.save(this.output);
    }

    private ResourceManager getResourceManager() {
        Predicate<URL> predicate = this.resourcesPolicy != null ? this.resourcesPolicy : DEFAULT_RESOURCE_POLICY;
        long limit = this.resourcesLimit >= 0L ? this.resourcesLimit : Long.MAX_VALUE;
        return new ResourceManagerImpl(this.input.getResources(), predicate, limit);
    }

    private InputStream getTemplate() {
        if (this.template != null) {
            return this.template;
        }
        return System.class.getResourceAsStream(DEFAULT_TEMPLATE);
    }
}

