/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.kiv.md2odt;

import com.vladsch.flexmark.Extension;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.emoji.EmojiExtension;
import com.vladsch.flexmark.ext.escaped.character.EscapedCharacterExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughSubscriptExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.SubscriptExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.toc.SimTocExtension;
import com.vladsch.flexmark.ext.toc.TocExtension;
import com.vladsch.flexmark.superscript.SuperscriptExtension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class FlexMarkExtensions {
    private final Set<String> selected = new HashSet<String>();

    FlexMarkExtensions() {
    }

    void add(String extension) {
        this.selected.add(extension);
    }

    List<Extension> getExtensions() {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        extensions.add(EscapedCharacterExtension.create());
        boolean enableAutolinks = this.selected.contains("AUTOLINKS");
        boolean enableEmoji = this.selected.contains("EMOJI");
        boolean enableStrikethrough = this.selected.contains("STRIKETHROUGH");
        boolean enableSubscript = this.selected.contains("SUBSCRIPT");
        boolean enableSuperscript = this.selected.contains("SUPERSCRIPT");
        boolean enableTables = this.selected.contains("TABLES");
        boolean enableTableOfContents = this.selected.contains("TABLE OF CONTENTS");
        if (enableAutolinks) {
            extensions.add(AutolinkExtension.create());
        }
        if (enableEmoji) {
            extensions.add(EmojiExtension.create());
        }
        if (enableSuperscript) {
            extensions.add(SuperscriptExtension.create());
        }
        if (enableTables) {
            extensions.add(TablesExtension.create());
        }
        if (enableStrikethrough && enableSubscript) {
            extensions.add(StrikethroughSubscriptExtension.create());
        } else if (enableStrikethrough) {
            extensions.add(StrikethroughExtension.create());
        } else if (enableSubscript) {
            extensions.add(SubscriptExtension.create());
        }
        if (enableTableOfContents) {
            extensions.add(TocExtension.create());
            extensions.add(SimTocExtension.create());
        }
        return extensions;
    }
}

